<?php
	/*	
	*	Goodlayers Option
	*	---------------------------------------------------------------------
	*	This file store an array of theme options
	*	---------------------------------------------------------------------
	*/	

	$infinite_admin_option->add_element(array(
	
		// typography head section
		'title' => esc_html__('Typography', 'infinite'),
		'slug' => INFINITE_SHORT_NAME . '_typography',
		'icon' => get_template_directory_uri() . '/include/options/images/typography.png',
		'options' => array(
		
			// starting the subnav
			'font-family' => array(
				'title' => esc_html__('Font Family', 'infinite'),
				'options' => array(
					'disable-google-font' => array(
						'title' => esc_html__('Disable Google Font', 'infinite'),
						'type' => 'checkbox',
						'default' => 'disbale',
						'description' => esc_html__('Enable this option when the google font is included by external plugins.', 'infinite')
					),
					'google-font-display' => array(
						'title' => esc_html__('Google Font Display', 'infinite'),
						'type' => 'combobox',
						'options' => array( 
							'' => esc_html__('Auto', 'infinite'),
							'block' => esc_html__('Block', 'infinite'),
							'swap' => esc_html__('Swap', 'infinite'),
							'fallback' => esc_html__('Fall Back', 'infinite'),
							'optional' => esc_html__('Optional', 'infinite'),
						),
						'default' => 'optional',
						'description' => wp_kses(__('This option could increase the page speed result of your site. You can learn more about the font display <a href="https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display" target="_blank" >here</a>', 'infinite'), array('a'=>array('href'=>array(), 'target'=>array())))
					),
					'heading-font' => array(
						'title' => esc_html__('Heading Font', 'infinite'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.infinite-body h1, .infinite-body h2, .infinite-body h3, ' . 
							'.infinite-body h4, .infinite-body h5, .infinite-body h6, .infinite-body .infinite-title-font,' .
							'.infinite-body .gdlr-core-title-font{ font-family: #gdlr#; }' . 
							'.woocommerce-breadcrumb, .woocommerce span.onsale, ' .
							'.single-product.woocommerce div.product p.price .woocommerce-Price-amount, .single-product.woocommerce #review_form #respond label{ font-family: #gdlr#; }'
					),
					'navigation-font' => array(
						'title' => esc_html__('Navigation Font', 'infinite'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.infinite-navigation .sf-menu > li > a, .infinite-navigation .sf-vertical > li > a, .infinite-navigation-font{ font-family: #gdlr#; }'
					),	
					'content-font' => array(
						'title' => esc_html__('Content Font', 'infinite'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.infinite-body, .infinite-body .gdlr-core-content-font, ' . 
							'.infinite-body input, .infinite-body textarea, .infinite-body button, .infinite-body select, ' . 
							'.infinite-body .infinite-content-font, .gdlr-core-audio .mejs-container *{ font-family: #gdlr#; }'
					),
					'info-font' => array(
						'title' => esc_html__('Info Font', 'infinite'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.infinite-body .gdlr-core-info-font, .infinite-body .infinite-info-font{ font-family: #gdlr#; }'
					),
					'blog-info-font' => array(
						'title' => esc_html__('Blog Info Font', 'infinite'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.infinite-body .gdlr-core-blog-info-font, .infinite-body .infinite-blog-info-font{ font-family: #gdlr#; }'
					),
					'quote-font' => array(
						'title' => esc_html__('Quote Font', 'infinite'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.infinite-body .gdlr-core-quote-font, blockquote{ font-family: #gdlr#; }'
					),
					'testimonial-font' => array(
						'title' => esc_html__('Testimonial Font', 'infinite'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.infinite-body .gdlr-core-testimonial-content{ font-family: #gdlr#; }'
					),
					'additional-font' => array(
						'title' => esc_html__('Additional Font', 'infinite'),
						'type' => 'font',
						'data-type' => 'font',
						'customizer' => false,
						'default' => 'Georgia, serif',
						'description' => esc_html__('Additional font you want to include for custom css.', 'infinite'),
						'selector' => '.infinite-additional-font{ font-family: #gdlr# !important; }'
					),
					'additional-font2' => array(
						'title' => esc_html__('Additional Font2', 'infinite'),
						'type' => 'font',
						'data-type' => 'font',
						'customizer' => false,
						'default' => 'Georgia, serif',
						'description' => esc_html__('Additional font you want to include for custom css.', 'infinite'),
						'selector' => '.infinite-additional-font2{ font-family: #gdlr# !important; }'
					),
					
				) // font-family-options
			), // font-family-nav
			
			'font-size' => array(
				'title' => esc_html__('Font Size', 'infinite'),
				'options' => array(
				
					'h1-font-size' => array(
						'title' => esc_html__('H1 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '52px',
						'selector' => '.infinite-body h1{ font-size: #gdlr#; }'
					),					
					'h2-font-size' => array(
						'title' => esc_html__('H2 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '48px',
						'selector' => '.infinite-body h2, #poststuff .gdlr-core-page-builder-body h2{ font-size: #gdlr#; }' 
					),					
					'h3-font-size' => array(
						'title' => esc_html__('H3 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '36px',
						'selector' => '.infinite-body h3{ font-size: #gdlr#; }' 
					),					
					'h4-font-size' => array(
						'title' => esc_html__('H4 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '28px',
						'selector' => '.infinite-body h4{ font-size: #gdlr#; }' 
					),					
					'h5-font-size' => array(
						'title' => esc_html__('H5 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '22px',
						'selector' => '.infinite-body h5{ font-size: #gdlr#; }' 
					),					
					'h6-font-size' => array(
						'title' => esc_html__('H6 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '18px',
						'selector' => '.infinite-body h6{ font-size: #gdlr#; }' 
					),				
					'header-font-weight' => array(
						'title' => esc_html__('Header Font Weight', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.infinite-body h1, .infinite-body h2, .infinite-body h3, .infinite-body h4, .infinite-body h5, .infinite-body h6{ font-weight: #gdlr#; }' . 
							'#poststuff .gdlr-core-page-builder-body h1, #poststuff .gdlr-core-page-builder-body h2{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'infinite')
					),
					'content-font-size' => array(
						'title' => esc_html__('Content Font Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '15px',
						'selector' => '.infinite-body{ font-size: #gdlr#; }' 
					),
					'content-font-weight' => array(
						'title' => esc_html__('Content Font Weight', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.infinite-body{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'infinite')
					),
					'content-line-height' => array(
						'title' => esc_html__('Content Line Height', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'default' => '1.7',
						'selector' => '.infinite-body, .infinite-line-height, .gdlr-core-line-height{ line-height: #gdlr#; }'
					),
					
				) // font-size-options
			), // font-size-nav			
			
			'mobile-font-size' => array(
				'title' => esc_html__('Mobile Font Size', 'infinite'),
				'options' => array(

					'mobile-h1-font-size' => array(
						'title' => esc_html__('Mobile H1 Size', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .infinite-body h1{ font-size: #gdlr#; } }' 
					),
					'mobile-h2-font-size' => array(
						'title' => esc_html__('Mobile H2 Size', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .infinite-body h2, #poststuff .gdlr-core-page-builder-body h2{ font-size: #gdlr#; } }' 
					),
					'mobile-h3-font-size' => array(
						'title' => esc_html__('Mobile H3 Size', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .infinite-body h3{ font-size: #gdlr#; } }' 
					),
					'mobile-h4-font-size' => array(
						'title' => esc_html__('Mobile H4 Size', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .infinite-body h4{ font-size: #gdlr#; } }' 
					),
					'mobile-h5-font-size' => array(
						'title' => esc_html__('Mobile H5 Size', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .infinite-body h5{ font-size: #gdlr#; } }' 
					),
					'mobile-h6-font-size' => array(
						'title' => esc_html__('Mobile H6 Size', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .infinite-body h6{ font-size: #gdlr#; } }' 
					),					
					'mobile-content-font-size' => array(
						'title' => esc_html__('Mobile Content Font Size', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .infinite-body{ font-size: #gdlr#; } }' 
					),

				)
			),

			'navigation-font-size' => array(
				'title' => esc_html__('Navigation Font Size', 'infinite'),
				'options' => array(	
					'navigation-font-size' => array(
						'title' => esc_html__('Navigation Font Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '14px',
						'selector' => '.infinite-navigation .sf-menu > li > a, .infinite-navigation .sf-vertical > li > a{ font-size: #gdlr#; }' 
					),	
					'navigation-font-weight' => array(
						'title' => esc_html__('Navigation Font Weight', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'default' => '800',
						'selector' => '.infinite-navigation .sf-menu > li > a, .infinite-navigation .sf-vertical > li > a{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'infinite')
					),	
					'navigation-font-letter-spacing' => array(
						'title' => esc_html__('Navigation Font Letter Spacing', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.infinite-navigation .sf-menu > li > a, .infinite-navigation .sf-vertical > li > a{ letter-spacing: #gdlr#; }'
					),
					'navigation-text-transform' => array(
						'title' => esc_html__('Navigation Text Transform', 'infinite'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'infinite'),
							'lowercase' => esc_html__('Lowercase', 'infinite'),
							'capitalize' => esc_html__('Capitalize', 'infinite'),
							'none' => esc_html__('None', 'infinite'),
						),
						'default' => 'uppercase',
						'selector' => '.infinite-navigation .sf-menu > li > a, .infinite-navigation .sf-vertical > li > a{ text-transform: #gdlr#; }',
					),
					'sub-navigation-font-size' => array(
						'title' => esc_html__('Sub Navigation Font Size', 'infinite'),
						'type' => 'text',
						'data-input-type' => 'pixel',
						'data-type' => 'pixel',
						'selector' => '.infinite-navigation .sf-menu > .infinite-normal-menu .sub-menu, .infinite-navigation .sf-menu>.infinite-mega-menu .sf-mega-section-inner .sub-menu a{ font-size: #gdlr#; }' 
					),
					'sub-navigation-font-weight' => array(
						'title' => esc_html__('Sub Navigation Font Weight', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'default' => '800',
						'selector' => '.infinite-navigation .sf-menu > .infinite-normal-menu .sub-menu, .infinite-navigation .sf-menu>.infinite-mega-menu .sf-mega-section-inner .sub-menu a{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'infinite')
					),	
					'sub-navigation-font-letter-spacing' => array(
						'title' => esc_html__('Sub Navigation Font Letter Spacing', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.infinite-navigation .sf-menu > .infinite-normal-menu .sub-menu, .infinite-navigation .sf-menu>.infinite-mega-menu .sf-mega-section-inner .sub-menu a{ letter-spacing: #gdlr#; }'
					),
					'sub-navigation-text-transform' => array(
						'title' => esc_html__('Sub Navigation Text Transform', 'infinite'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'infinite'),
							'lowercase' => esc_html__('Lowercase', 'infinite'),
							'capitalize' => esc_html__('Capitalize', 'infinite'),
							'none' => esc_html__('None', 'infinite'),
						),
						'default' => 'uppercase',
						'selector' => '.infinite-navigation .sf-menu > .infinite-normal-menu .sub-menu, .infinite-navigation .sf-menu>.infinite-mega-menu .sf-mega-section-inner .sub-menu a{ text-transform: #gdlr#; }',
					),
					'navigation-right-button-font-size' => array(
						'title' => esc_html__('Navigation Right Button Font Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '11px',
						'selector' => '.infinite-main-menu-right-button{ font-size: #gdlr#; }' 
					),	
					'navigation-right-button-font-weight' => array(
						'title' => esc_html__('Navigation Right Button Font Weight', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.infinite-main-menu-right-button{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'infinite')
					),	
					'navigation-right-button-font-letter-spacing' => array(
						'title' => esc_html__('Navigation Right Button Font Letter Spacing', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.infinite-main-menu-right-button{ letter-spacing: #gdlr#; }'
					),
					'navigation-right-button-text-transform' => array(
						'title' => esc_html__('Navigation Right Button Text Transform', 'infinite'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'infinite'),
							'lowercase' => esc_html__('Lowercase', 'infinite'),
							'capitalize' => esc_html__('Capitalize', 'infinite'),
							'none' => esc_html__('None', 'infinite'),
						),
						'default' => 'uppercase',
						'selector' => '.infinite-main-menu-right-button{ text-transform: #gdlr#; }',
					),
				) // font-size-options
			), // font-size-nav
			
			'footer-font-size' => array(
				'title' => esc_html__('Sidebar / Footer Font Size', 'infinite'),
				'options' => array(
					
					'widget-h1-font-size' => array(
						'title' => esc_html__('Widget H1 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '52px',
						'selector' => '.infinite-widget h1{ font-size: #gdlr#; }',
						'description' => esc_html__('For Heading Widget item', 'infinite')
					),					
					'widget-h2-font-size' => array(
						'title' => esc_html__('Widget H2 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '48px',
						'selector' => '.infinite-widget h2{ font-size: #gdlr#; }',
						'description' => esc_html__('For Heading Widget item', 'infinite')
					),					
					'widget-h3-font-size' => array(
						'title' => esc_html__('Widget H3 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '36px',
						'selector' => '.infinite-widget h3{ font-size: #gdlr#; }',
						'description' => esc_html__('For Heading Widget item', 'infinite')
					),					
					'widget-h4-font-size' => array(
						'title' => esc_html__('Widget H4 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '28px',
						'selector' => '.infinite-widget h4{ font-size: #gdlr#; }',
						'description' => esc_html__('For Heading Widget item', 'infinite')
					),					
					'widget-h5-font-size' => array(
						'title' => esc_html__('Widget H5 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '22px',
						'selector' => '.infinite-widget h5{ font-size: #gdlr#; }',
						'description' => esc_html__('For Heading Widget item', 'infinite')
					),					
					'widget-h6-font-size' => array(
						'title' => esc_html__('Widget H6 Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '18px',
						'selector' => '.infinite-widget h6{ font-size: #gdlr#; }',
						'description' => esc_html__('For Heading Widget item', 'infinite')
					),
					'widget-heading-font-weight' => array(
						'title' => esc_html__('Widget Heading Font Weight', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.infinite-widget h1, .infinite-widget h2, .infinite-widget h3, .infinite-widget h4, .infinite-widget h5, .infinite-widget h6{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'infinite')
					),	
					'widget-heading-letter-spacing' => array(
						'title' => esc_html__('Widget Heading Letter Spacing', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.infinite-widget h1, .infinite-widget h2, .infinite-widget h3, .infinite-widget h4, .infinite-widget h5, .infinite-widget h6{ letter-spacing: #gdlr#; }'
					),
					'widget-heading-text-transform' => array(
						'title' => esc_html__('Widget Heading Text Transform', 'infinite'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'infinite'),
							'lowercase' => esc_html__('Lowercase', 'infinite'),
							'capitalize' => esc_html__('Capitalize', 'infinite'),
							'none' => esc_html__('None', 'infinite'),
						),
						'default' => 'none',
						'selector' => '.infinite-widget h1, .infinite-widget h2, .infinite-widget h3, .infinite-widget h4, .infinite-widget h5, .infinite-widget h6{ text-transform: #gdlr#; }',
					),

					'sidebar-title-font-size' => array(
						'title' => esc_html__('Sidebar Title Font Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '13px',
						'selector' => '.infinite-sidebar-area .infinite-widget-title{ font-size: #gdlr#; }' 
					),
					'sidebar-title-font-weight' => array(
						'title' => esc_html__('Sidebar Title Font Weight', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.infinite-sidebar-area .infinite-widget-title{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'infinite')
					),	
					'sidebar-title-font-letter-spacing' => array(
						'title' => esc_html__('Sidebar Title Font Letter Spacing', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.infinite-sidebar-area .infinite-widget-title{ letter-spacing: #gdlr#; }'
					),
					'sidebar-title-text-transform' => array(
						'title' => esc_html__('Sidebar Title Text Transform', 'infinite'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'infinite'),
							'lowercase' => esc_html__('Lowercase', 'infinite'),
							'capitalize' => esc_html__('Capitalize', 'infinite'),
							'none' => esc_html__('None', 'infinite'),
						),
						'default' => 'uppercase',
						'selector' => '.infinite-sidebar-area .infinite-widget-title{ text-transform: #gdlr#; }',
					),
					'footer-title-font-size' => array(
						'title' => esc_html__('Footer Title Font Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '13px',
						'selector' => '.infinite-footer-wrapper .infinite-widget-title{ font-size: #gdlr#; }' 
					),
					'footer-title-font-weight' => array(
						'title' => esc_html__('Footer Title Font Weight', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.infinite-footer-wrapper .infinite-widget-title{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'infinite')
					),	
					'footer-title-font-letter-spacing' => array(
						'title' => esc_html__('Footer Title Font Letter Spacing', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.infinite-footer-wrapper .infinite-widget-title{ letter-spacing: #gdlr#; }' . 
							'.infinite-footer-wrapper .infinite-widget h1, .infinite-footer-wrapper .infinite-widget h2, .infinite-footer-wrapper .infinite-widget h3, .infinite-footer-wrapper .infinite-widget h4, .infinite-footer-wrapper .infinite-widget h5, .infinite-footer-wrapper .infinite-widget h6{ letter-spacing: #gdlr#; }'
					),
					'footer-title-text-transform' => array(
						'title' => esc_html__('Footer Title Text Transform', 'infinite'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'infinite'),
							'lowercase' => esc_html__('Lowercase', 'infinite'),
							'capitalize' => esc_html__('Capitalize', 'infinite'),
							'none' => esc_html__('None', 'infinite'),
						),
						'default' => 'uppercase',
						'selector' => '.infinite-footer-wrapper .infinite-widget-title{ text-transform: #gdlr#; }',
					),
					'footer-font-size' => array(
						'title' => esc_html__('Footer Content Font Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '15px',
						'selector' => '.infinite-footer-wrapper{ font-size: #gdlr#; }' 
					),
					'footer-content-font-weight' => array(
						'title' => esc_html__('Footer Content Font Weight', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.infinite-footer-wrapper .widget_text{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'infinite')
					),	
					'footer-content-text-transform' => array(
						'title' => esc_html__('Footer Content Text Transform', 'infinite'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'infinite'),
							'lowercase' => esc_html__('Lowercase', 'infinite'),
							'capitalize' => esc_html__('Capitalize', 'infinite'),
							'none' => esc_html__('None', 'infinite'),
						),
						'default' => 'none',
						'selector' => '.infinite-footer-wrapper .widget_text{ text-transform: #gdlr#; }',
					),
					'copyright-font-size' => array(
						'title' => esc_html__('Copyright Font Size', 'infinite'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '14px',
						'selector' => '.infinite-copyright-text, .infinite-copyright-left, .infinite-copyright-right{ font-size: #gdlr#; }' 
					),
					'copyright-font-weight' => array(
						'title' => esc_html__('Copyright Font Weight', 'infinite'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.infinite-copyright-text, .infinite-copyright-left, .infinite-copyright-right{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'infinite')
					),	
					'copyright-font-letter-spacing' => array(
						'title' => esc_html__('Copyright Font Letter Spacing', 'infinite'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.infinite-copyright-text, .infinite-copyright-left, .infinite-copyright-right{ letter-spacing: #gdlr#; }'
					),
					'copyright-text-transform' => array(
						'title' => esc_html__('Copyright Text Transform', 'infinite'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'infinite'),
							'lowercase' => esc_html__('Lowercase', 'infinite'),
							'capitalize' => esc_html__('Capitalize', 'infinite'),
							'none' => esc_html__('None', 'infinite'),
						),
						'default' => 'uppercase',
						'selector' => '.infinite-copyright-text, .infinite-copyright-left, .infinite-copyright-right{ text-transform: #gdlr#; }',
					),
				)
			),

			'font-upload' => array(
				'title' => esc_html__('Font Uploader', 'infinite'),
				'reload-after' => true,
				'customizer' => false,
				'options' => array(
					
					'font-upload' => array(
						'title' => esc_html__('Upload Fonts', 'infinite'),
						'type' => 'custom',
						'item-type' => 'fontupload',
						'wrapper-class' => 'gdlr-core-fullsize',
					),
					
				) // fontupload-options
			), // fontupload-nav
		
		) // typography-options
		
	), 4);