<?php 
	/*	
	*	Goodlayers Core Plugin Filter
	*	---------------------------------------------------------------------
	*	This file contains the script to includes necessary function
	* 	for compatibility with goodlayers core plugin
	*	---------------------------------------------------------------------
	*/

	add_filter('gdlr_core_pb_element_title_heading_tag_class', 'infinite_gdlr_core_pb_element_title_heading_tag_class', 10, 2);
	if( !function_exists('infinite_gdlr_core_pb_element_title_heading_tag_class') ){
		function infinite_gdlr_core_pb_element_title_heading_tag_class( $classes, $settings ){
			if( !empty($settings['title-font-family']) && $settings['title-font-family'] != 'heading-font' ){
				$classes = 'infinite-' . $settings['title-font-family'];
			}
			return $classes . ' class-test';
		}
	}
	add_filter('gdlr_core_title_item_options', 'infinite_gdlr_core_title_item_options');
	if( !function_exists('infinite_gdlr_core_title_item_options') ){
		function infinite_gdlr_core_title_item_options( $options ){
			$options['typography']['options'] = array(
				'title-font-family' => array(
				'title' => esc_html__('Title Font Family', 'infinite'),
				'type' => 'combobox',
				'options' => array(
					'heading-font' => esc_html__('Heading Font', 'infinite'),
					'additional-font' => esc_html__('Additional Font', 'infinite'),
					'additional-font2' => esc_html__('Additional Font 2', 'infinite'),
				)
			)) + $options['typography']['options'];

			return $options;
		}
	}
	
	add_filter('gdlr_core_use_font_icons', 'infinite_gdlr_core_use_font_icons');
	if( !function_exists('infinite_gdlr_core_use_font_icons') ){
		function infinite_gdlr_core_use_font_icons( $icons ){
			return infinite_get_option('plugin', 'font-icon', $icons);
		}
	} 

	// add body class for page builder
	add_filter('gdlr_core_page_builder_body_class', 'infinite_page_builder_body_class');
	if( !function_exists('infinite_page_builder_body_class') ){
		function infinite_page_builder_body_class( $classes ) {
			return $classes . ' infinite-body';
		}
	}
	add_filter('gdlr_core_sidebar_class', 'infinite_gdlr_core_sidebar_class');
	if( !function_exists('infinite_gdlr_core_sidebar_class') ){
		function infinite_gdlr_core_sidebar_class( $classes ) {
			return $classes . ' infinite-sidebar-area';
		}
	}

	// Set the neccessary function to be used in the theme
	add_action('after_setup_theme', 'infinite_goodlayers_core_setup');
	if( !function_exists( 'infinite_goodlayers_core_setup' ) ){
		function infinite_goodlayers_core_setup(){

			// to set the goodlayers core plugin pagination
			add_filter('gdlr_core_pagination_style', 'infinite_gdlr_core_pagination_style');
			add_filter('gdlr_core_pagination_align', 'infinite_gdlr_core_pagination_align');

			// set the default social share option
			add_filter('gdlr_core_social_share_list', 'infinite_gdlr_core_social_share_list');

			// widget title navigation
			add_filter('gdlr_core_widget_title_nav', 'infinite_gdlr_core_widget_title_nav');

			// single portfolio
			add_filter('gdlr_core_custom_post_slug', 'infinite_gdlr_core_custom_post_slug', 10, 2);

			add_filter('gdlr_core_portfolio_single_nav', 'infinite_gdlr_core_portfolio_single_nav');
			add_filter('gdlr_core_portfolio_single_nav_same_term', 'infinite_gdlr_core_portfolio_single_nav_same_term');
			add_filter('gdlr_core_portfolio_single_nav_middle_link', 'infinite_gdlr_core_portfolio_single_nav_middle_link');
			add_filter('gdlr_core_portfolio_single_related', 'infinite_gdlr_core_portfolio_single_related');

			// srcset
			add_filter('gdlr_core_enable_srcset', 'infinite_gdlr_core_enable_srcset');

			// filter for portfolio icon hover
			add_filter('gdlr_core_portfolio_hover_icon_class', 'infinite_gdlr_core_portfolio_hover_icon_class');

			// youtube cookies
			add_filter('gdlr_core_privacy_settings', 'infinite_gdlr_core_privacy_settings');
		}
	}

	// youtube no cookies
	if( !function_exists('infinite_gdlr_core_privacy_settings') ){
		function infinite_gdlr_core_privacy_settings(){
			if( function_exists('gdlr_core_get_privacy_options') ){
				$privacy_options = gdlr_core_get_privacy_options(1) + gdlr_core_get_privacy_options(2);
				$privacy_settings = array();
				foreach( $privacy_options as $privacy_option_slug => $privacy_option ){
					$privacy_settings[$privacy_option_slug] = infinite_get_option('plugin', $privacy_option_slug, 
						(empty($privacy_option['default'])? '': $privacy_option['default']));
				}

				return $privacy_settings;
			}
			
			return array();
		}
	}

	add_filter('gdlr_core_google_font_display', 'infinite_gdlr_core_google_font_display');
	if( !function_exists('infinite_gdlr_core_google_font_display') ){
		function infinite_gdlr_core_google_font_display( $display ){
			return infinite_get_option('typography', 'google-font-display', '');
		}
	}
	

	// portfolio hover icon class
	if( !function_exists('infinite_gdlr_core_portfolio_hover_icon_class') ){
		function infinite_gdlr_core_portfolio_hover_icon_class( $type = '' ){
			if( $type == 'image' ){
			 	return infinite_get_option('general', 'portfolio-icon-hover-image', '');
			}else if( $type == 'video' ){
				return infinite_get_option('general', 'portfolio-icon-hover-video', '');
			}else if( $type == 'link' ){
				return infinite_get_option('general', 'portfolio-icon-hover-link', '');
			}
		}
	}

	// to enable srcset
	if( !function_exists('infinite_gdlr_core_enable_srcset') ){
		function infinite_gdlr_core_enable_srcset( $enable ){
			$enable_srcset = infinite_get_option('plugin', 'enable-srcset', 'disable');
			return ($enable_srcset == 'enable');
		}
	}

	// woocommerce shop amount
	add_filter('loop_shop_per_page', 'infinite_loop_shop_per_page', 9999);
	function infinite_loop_shop_per_page($per_page){
		$per_page = infinite_get_option('general', 'woocommerce-archive-product-amount', $per_page);
		return $per_page;
	}
			
	// for goodlayers core pagination
	if( !function_exists('infinite_gdlr_core_pagination_style') ){
		function infinite_gdlr_core_pagination_style( $style ) {
			return infinite_get_option('general', 'pagination-style', $style);
		}
	}
	if( !function_exists('infinite_gdlr_core_pagination_align') ){
		function infinite_gdlr_core_pagination_align( $align ) {
			return infinite_get_option('general', 'pagination-align', $align);
		}
	}			

	// custom post type slug
	if( !function_exists('infinite_gdlr_core_custom_post_slug') ){
		function infinite_gdlr_core_custom_post_slug( $slug, $type = '' ) {
			if( empty($type) ){ $type = $slug; }

			if( $type == 'portfolio' ){
				$slug = infinite_get_option('general', 'portfolio-slug', $slug);
			}else if( $type == 'portfolio_category' ){
				$slug = infinite_get_option('general', 'portfolio-category-slug', $slug);
			}else if( $type == 'portfolio_tag' ){
				$slug = infinite_get_option('general', 'portfolio-tag-slug', $slug);
			}else if( $type == 'personnel' ){
				$slug = infinite_get_option('general', 'personnel-slug', $slug);
			}else if( $type == 'personnel_category' ){
				$slug = infinite_get_option('general', 'personnel-category-slug', $slug);
			}
			
			return $slug;
		}
	}

	// single portfolio
	if( !function_exists('infinite_gdlr_core_portfolio_single_nav') ){
		function infinite_gdlr_core_portfolio_single_nav( $check ) {
			return infinite_get_option('general', 'enable-single-portfolio-navigation', $check);
		}
	}
	if( !function_exists('infinite_gdlr_core_portfolio_single_nav_same_term') ){
		function infinite_gdlr_core_portfolio_single_nav_same_term( $check ) {
			return infinite_get_option('general', 'enable-single-portfolio-navigation-in-same-tag', $check);
		}
	}
	if( !function_exists('infinite_gdlr_core_portfolio_single_nav_middle_link') ){
		function infinite_gdlr_core_portfolio_single_nav_middle_link( $check ) {
			return infinite_get_option('general', 'single-portfolio-navigation-middle-link', $check);
		}
	}
	if( !function_exists('infinite_gdlr_core_portfolio_single_related') ){
		function infinite_gdlr_core_portfolio_single_related( $args ) {

			$enble_related_portfolio = infinite_get_option('general', 'enable-related-portfolio', 'enable');
			if( $enble_related_portfolio == 'enable' ){
				$args['portfolio-style'] = infinite_get_option('general', 'related-portfolio-style', 'grid');
				$args['num-fetch'] = infinite_get_option('general', 'related-portfolio-num-fetch', 4);
				$args['column-size'] = infinite_get_option('general', 'related-portfolio-column-size', 15);
				$args['thumbnail-size'] = infinite_get_option('general', 'related-portfolio-thumbnail-size', 'medium');
				$args['excerpt-number'] = infinite_get_option('general', 'related-portfolio-num-excerpt', 20);
				$args['column-size'] = infinite_get_option('general', 'related-portfolio-column-size', 15);

				return $args;
			}else{
				return array();
			}
		}
	}

	// set default social share option
	if( !function_exists('infinite_gdlr_core_social_share_list') ){
		function infinite_gdlr_core_social_share_list( $social ) {

			$social['facebook'] = infinite_get_option('general', 'blog-social-facebook', $social['facebook']);
			$social['linkedin'] = infinite_get_option('general', 'blog-social-linkedin', $social['linkedin']);
			$social['pinterest'] = infinite_get_option('general', 'blog-social-pinterest', $social['pinterest']);
			$social['stumbleupon'] = infinite_get_option('general', 'blog-social-stumbleupon', $social['stumbleupon']);
			$social['twitter'] = infinite_get_option('general', 'blog-social-twitter', $social['twitter']);
			$social['email'] = infinite_get_option('general', 'blog-social-email', $social['email']);

			return $social;
		}
	}	

	// add filter to register custom fonts for font lists 
	add_filter('gdlr_core_custom_uploaded_font', 'infinite_register_custom_uploaded_font');
	if( !function_exists('infinite_register_custom_uploaded_font') ){
		function infinite_register_custom_uploaded_font( $custom_fonts ){

			$custom_font = infinite_get_option('typography', 'font-upload');
			if( !empty($custom_font) ){
				foreach($custom_font as $font_option){
					$font_option['name'] = str_replace('+', '', $font_option['name']);
					while( !empty($custom_fonts[$font_option['name']]) ){
						$font_option['name'] = $font_option['name'] . '+';
					}

					$custom_fonts[$font_option['name']] = array(
						'eot' => empty($font_option['eot'])? '': $font_option['eot'],
						'ttf' => empty($font_option['ttf'])? '': $font_option['ttf'],
						'woff' => empty($font_option['woff'])? '': $font_option['woff'],
						'font-weight' => empty($font_option['font-weight'])? 'normal': $font_option['font-weight'],
						'font-style' => empty($font_option['font-style'])? 'normal': $font_option['font-style']
					);
				}
			}		
			
			return $custom_fonts;
			
		} // infinite_register_custom_uploaded_font
	} // function_exists

	// format widget title
	if( !function_exists('infinite_gdlr_core_widget_title_nav') ){
		function infinite_gdlr_core_widget_title_nav( $title_nav ){
			return '</span><span class="gdlr-core-flexslider-nav gdlr-core-plain-style gdlr-core-size-widget">';
		}
	}
	
	// add page builder to post
	add_filter('gdlr_core_page_builder_post_type', 'infinite_gdlr_core_page_builder_post_type');
	if( !function_exists('infinite_gdlr_core_page_builder_post_type') ){
		function infinite_gdlr_core_page_builder_post_type( $post_types ){
			$post_types[] = 'post';
			return $post_types;
		}
	}

	// set lightbox type
	add_filter('gdlr_core_lightbox_type', 'infinite_gdlr_core_lightbox_type');
	if( !function_exists('infinite_gdlr_core_lightbox_type') ){
		function infinite_gdlr_core_lightbox_type(){
			$lightbox_type = infinite_get_option('plugin', 'lightbox', 'ilightbox');

			if( $lightbox_type == 'ilightbox' ){
				$ilightbox_skin = infinite_get_option('plugin', 'ilightbox-skin', 'dark');
				return $lightbox_type . '-' . $ilightbox_skin;
			}else{
				return $lightbox_type;
			}
		}
	}
	add_filter('body_class', 'infinite_lightbox_body_class');
	if( !function_exists('infinite_lightbox_body_class') ){
		function infinite_lightbox_body_class($class){
			$link_to_lightbox = infinite_get_option('plugin', 'link-to-lightbox', 'enable');
			if( $link_to_lightbox == 'enable' ){
				$class[] = 'gdlr-core-link-to-lightbox';
			}
			return $class;
		}
	}

	add_filter('gdlr_core_lightbox_video_autoplay', 'infinite_lightbox_video_autoplay');
	if( !function_exists('infinite_lightbox_video_autoplay') ){
		function infinite_lightbox_video_autoplay($autoplay){
			$video_autoplay = infinite_get_option('plugin', 'lightbox-video-autoplay', 'enable');
			return ($video_autoplay == 'enable')? true: false;
		}
	}
	
	
	// add page builder pre defined template
	if( is_admin() && class_exists('gdlr_core_page_builder_template') ){
		add_filter('gdlr_core_page_builder_page_template_list', 'infinite_gdlr_core_page_builder_page_template_list');
		add_filter('gdlr_core_page_builder_get_page_template', 'infinite_gdlr_core_page_builder_get_page_template', 10, 2);
	}

	if( !function_exists('infinite_gdlr_core_page_builder_page_template_list') ){
		function infinite_gdlr_core_page_builder_page_template_list( $templates ){
			$templates['home-main'] = array(
				'title' => esc_html__('Home - Main', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-main2'] = array(
				'title' => esc_html__('Home - Main 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-main3'] = array(
				'title' => esc_html__('Home - Main 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-main4'] = array(
				'title' => esc_html__('Home - Main 4', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-construction'] = array(
				'title' => esc_html__('Home - Construction', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-barber'] = array(
				'title' => esc_html__('Home - Barber', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-jewelry'] = array(
				'title' => esc_html__('Home - Jewelry', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-agency01'] = array(
				'title' => esc_html__('Home - Agency 01', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-aperture'] = array(
				'title' => esc_html__('Home - Aperture', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-appz'] = array(
				'title' => esc_html__('Home - Appz', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-architek'] = array(
				'title' => esc_html__('Home - Architek', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-big-corp'] = array(
				'title' => esc_html__('Home - Big Corp', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-breeze-biz'] = array(
				'title' => esc_html__('Home - Breeze Biz', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-beauty'] = array(
				'title' => esc_html__('Home - Breeze Biz', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-conference'] = array(
				'title' => esc_html__('Home - Conference', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-designer'] = array(
				'title' => esc_html__('Home - Designer', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-eco'] = array(
				'title' => esc_html__('Home - Eco', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-emporium'] = array(
				'title' => esc_html__('Home - Emporium', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-finance'] = array(
				'title' => esc_html__('Home - Finance', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-fitness'] = array(
				'title' => esc_html__('Home - Fitness', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-furniture'] = array(
				'title' => esc_html__('Home - Furniture', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-gardener'] = array(
				'title' => esc_html__('Home - Gardener', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-half-box'] = array(
				'title' => esc_html__('Home - Half Box', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-high-rise'] = array(
				'title' => esc_html__('Home - High Rise', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-inagency'] = array(
				'title' => esc_html__('Home - Inagency', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-incorporate'] = array(
				'title' => esc_html__('Home - Incorporate', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-mechanic'] = array(
				'title' => esc_html__('Home - Mechanic', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-medical'] = array(
				'title' => esc_html__('Home - Medical', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-modernize'] = array(
				'title' => esc_html__('Home - Modernize', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-one-page'] = array(
				'title' => esc_html__('Home - One Page', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-pet'] = array(
				'title' => esc_html__('Home - Pet', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-restaurant'] = array(
				'title' => esc_html__('Home - Restaurnat', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-software'] = array(
				'title' => esc_html__('Home - Software', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-transportation'] = array(
				'title' => esc_html__('Home - Transportation', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['home-yellow-black'] = array(
				'title' => esc_html__('Home - Yellow Black', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us'] = array(
				'title' => esc_html__('About Us', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us2'] = array(
				'title' => esc_html__('About Us 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us3'] = array(
				'title' => esc_html__('About Us 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us4'] = array(
				'title' => esc_html__('About Us 4', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us5'] = array(
				'title' => esc_html__('About Us 5 (Transportation)', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us6'] = array(
				'title' => esc_html__('About Us 6 (Furniture)', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us7'] = array(
				'title' => esc_html__('About Us 7 (Software)', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us8'] = array(
				'title' => esc_html__('About Us 8 (Eco)', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us9'] = array(
				'title' => esc_html__('About Us 9 (Pet)', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us10'] = array(
				'title' => esc_html__('About Us 10 (Beauty)', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-us11'] = array(
				'title' => esc_html__('About Us 11 (Restaurant)', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-our-team'] = array(
				'title' => esc_html__('About Our Team', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-our-team2'] = array(
				'title' => esc_html__('About Our Team 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-our-team3'] = array(
				'title' => esc_html__('About Our Team 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-our-team4'] = array(
				'title' => esc_html__('About Our Team 4', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-me'] = array(
				'title' => esc_html__('About Me', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-main4'] = array(
				'title' => esc_html__('About Main4', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-jewelry'] = array(
				'title' => esc_html__('About Jewelry', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-construction'] = array(
				'title' => esc_html__('About Construction', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['about-barber'] = array(
				'title' => esc_html__('About Barber', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['service'] = array(
				'title' => esc_html__('Service', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['service2'] = array(
				'title' => esc_html__('Service 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['service3'] = array(
				'title' => esc_html__('Service 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['contact'] = array(
				'title' => esc_html__('Contact', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['contact2'] = array(
				'title' => esc_html__('Contact 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['contact3'] = array(
				'title' => esc_html__('Contact 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['maintenance'] = array(
				'title' => esc_html__('Maintenance', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['coming-soom'] = array(
				'title' => esc_html__('Coming Soon', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-post-custom'] = array(
				'title' => esc_html__('Single Post Custom', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-post-custom2'] = array(
				'title' => esc_html__('Single Post Custom 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-post-custom3'] = array(
				'title' => esc_html__('Single Post Custom 3', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-post-custom4'] = array(
				'title' => esc_html__('Single Post Custom 4', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-vertical-info'] = array(
				'title' => esc_html__('Single Port Vertical Info', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-horizontal-info'] = array(
				'title' => esc_html__('Single Port Horizontal Info', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-full-image'] = array(
				'title' => esc_html__('Single Port Full Image', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-full-image2'] = array(
				'title' => esc_html__('Single Port Full Image 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-service'] = array(
				'title' => esc_html__('Single Port Service', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-service2'] = array(
				'title' => esc_html__('Single Port Service 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-creative'] = array(
				'title' => esc_html__('Single Port Creative', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-creative2'] = array(
				'title' => esc_html__('Single Port Creative 2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-half-box'] = array(
				'title' => esc_html__('Single Port Half Box', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-port-half-box2'] = array(
				'title' => esc_html__('Single Port Half Box', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-personnel'] = array(
				'title' => esc_html__('Single Personnel', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-personnel2'] = array(
				'title' => esc_html__('Single Personnel2', 'infinite'),
				'type' => 'wrapper',
			);
			$templates['single-personnel3'] = array(
				'title' => esc_html__('Single Personnel3', 'infinite'),
				'type' => 'wrapper',
			);
			return $templates;
		} // infinite_gdlr_core_page_builder_page_template_list
	} // function_exists

	if( !function_exists('infinite_gdlr_core_page_builder_get_page_template') ){
		function infinite_gdlr_core_page_builder_get_page_template( $value, $type ){

			if( !empty($value) ) return $value; 

			switch( $type ){
				case 'home-main': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"The most powerful theme on earth","title":"Infinite WordPress Theme","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.","button-text":"","button-link":"#","button-link-target":"_self","text-align":"center","caption-position":"above-title","title-size":"41px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"divider","value":{"id":"","type":"with-icon","icon-type":"image","image":"2156","icon":"fa fa-film","style":"dashed","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"","padding-bottom":"80px"}},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"GoodLayers Page Builder","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_desktop","icon-style":"normal","image":"","title":"Free Sliders Included","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_genius","icon-style":"normal","image":"","title":"Super Powerful Admin Panel","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lifesaver","icon-style":"normal","image":"","title":"Awesome Support","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_cloud-download_alt","icon-style":"normal","image":"","title":"Google font library","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_heart_alt","icon-style":"normal","image":"","title":"Very easy to use","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"2162","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"24","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"138px","right":"80px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"left","background-color":"#2d9bea","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.8","parallax-speed":"0.8","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"SAVE A LOT OF YOUR TIME","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ffffff","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"fa fa-comments-o","icon-style":"normal","image":"","title":"Friendly Support","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ffffff","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lock_alt","icon-style":"normal","image":"","title":"Very SECURE CODE","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#ffffff","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"138px","right":"0px","bottom":"0px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Blue Divider White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"With Brand New  GoodLayers Page Builder","caption":"Sections and wrapper can be manage easily","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"137px","padding-bottom":"50px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p><p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn\'t listen. She packed her seven versalia, put her initial into the belt and made.</p>","text-align":"left","font-size":"","padding-bottom":"15px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"95px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":null,"tag":null,"num-fetch":"8","thumbnail-size":"Portfolio Thumbnail Portrait","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"modern-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"icon-title-tag","column-size":"15","layout":"fitrows","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","show-read-more":"enable","title-align":"left","title":"Our Works ","caption":"Explore","read-more-text":"View More Works","read-more-link":"http://demo.goodlayers.com/infinite/portfolio","read-more-target":"_self","title-size":"43px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","portfolio-title-text-transform":"uppercase","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f1f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"2176","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2127","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"90px","right":"100px","bottom":"90px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Blue Divider","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Incredible Layouts","caption":"Limitless possibilities create","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"45px"}},{"template":"element","type":"icon-list","value":{"id":"","tabs":[{"icon":"icon_circle-slelected","icon-hover":"icon_check_alt2","title":"Full wrapper and sidebar wrapper"},{"icon":"icon_circle-slelected","icon-hover":"icon_check_alt2","title":"Columns wrappers"},{"icon":"icon_circle-slelected","icon-hover":"icon_check_alt2","title":"More than 40 element items"},{"icon":"icon_circle-slelected","icon-hover":"icon_check_alt2","title":"Many pre-built templates"}],"icon-size":"16px","content-size":"16px","list-bottom-margin":"7px","enable-divider":"disable","icon-background":"none","icon-color":"#9e9e9e","icon-background-color":"","content-color":"","border-color":"","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river.</p>","text-align":"left","font-size":"","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"155px","right":"100px","bottom":"130px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#2d9bea","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Blue","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"icon","value":{"id":"","icon":"icon_menu-circle_alt2","text-align":"left","icon-size":"60px","icon-color":"#ffffff","background":"none","background-padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-radius":"0px","background-color":"","background-border":"none","border-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border-color":"","pre-border-space":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","title":"Power Elite Author","caption":"Be wise and choose","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"45px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>We are the top author of Themeforest, Power Elite Author. There are not much authors who hit power eilite level and with 5 years of expereinces. We know what exactly you want. We promise to deliver the best products with great after sales support and we won\'t let you down.</p>","text-align":"left","font-size":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"400px","hide-this-wrapper-in":"mobile","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f1f0f0","background-image":"2181","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.4","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"400px","hide-this-wrapper-in":"mobile","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-3","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f1f0f0","background-image":"1877","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.2","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"185px","right":"100px","bottom":"155px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInRight","animation-location":"0.8","full-height":"disable","sync-height":"height-3","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#232323","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Dark","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Our New Framework","caption":"Are you ready to be amazed?","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"left","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"45px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>We had spent a lot of time to study, gather information and finally we come up with the best page builder in the world. It\'s the most powerful with many options and it has everything you need. You can push them into 3 modes, block mode, preview mode and live mode(frontend builder). Now with this tool, your imagination will be limitless.</p>","text-align":"left","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"130px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"2185","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"1","overflow":"visible","skin":"Blue Divider White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","suffix":"%","divider":"enable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"588","suffix":"","divider":"enable","bottom-text":"Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"16800","suffix":"","divider":"enable","bottom-text":"Working Hours","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"234","suffix":"","divider":"enable","bottom-text":"Lovely Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","bottom-text-size":"16px","bottom-text-transform":"uppercase","animation-time":"4000","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"1200px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"2187","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"mobile","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"2188","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2127","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"GoodLayers Page Builder","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_globe-2","icon-style":"normal","image":"","title":"Infinite Is Genius","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_globe","icon-style":"normal","image":"","title":"Your global business","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeIn","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_piechart","icon-style":"normal","image":"","title":"Business Strategy","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_cloud-upload_alt","icon-style":"normal","image":"","title":"Showcase Your Works","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_like","icon-style":"normal","image":"","title":"Thumbs Up!","caption":"The Big Oxmox advised her","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"30px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"#2d9bea","icon-background":"","title-size":"16px","title-font-weight":"","title-letter-spacing":"2px","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"personnel","value":{"id":"","category":null,"num-fetch":"4","thumbnail-size":"Personnel Thumbnail 2","orderby":"date","disable-link":"disable","order":"desc","title-align":"left","title":"Meet the genius team","caption":"Who are we?","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"43px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","text-align":"left","personnel-style":"grid-no-space","enable-position":"enable","enable-divider":"enable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"4","carousel":"disable","carousel-navigation":"navigation","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"850px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"125px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"2193","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"testimonial","value":{"id":"","title":"Testimonial","caption":"","tabs":[{"title":"John Smith","position":"Co-Founder","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.","image":"506","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-1.jpg"},{"title":"Sarah Lopez","position":"CFO, Apple","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.","image":"508","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-3.jpg"},{"title":"Robert Kim","position":"Customer","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents.","image":"507","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-2.jpg"}],"column":"1","carousel":"enable","carousel-autoslide":"enable","carousel-navigation":"navigation","style":"center","title-size":"43px","caption-size":"16px","content-size":"18px","title-color":"","caption-color":"","quote-color":"#ffffff","content-color":"#c4c4c4","name-color":"","position-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"1200px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"130px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#fafafa","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"Light Border","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"blog","value":{"id":"","category":["blog"],"tag":null,"num-fetch":"5","prepend-sticky":"disable","thumbnail-size":"Personnel Thumbnail","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","blog-style":"blog-column-with-frame","blog-full-alignment":"left","show-thumbnail":"enable","column-size":"20","layout":"carousel","carousel-autoslide":"disable","carousel-navigation":"both","item-size":"small","excerpt":"specify-number","excerpt-number":"18","meta-option":["date","author","category","comment-number"],"show-read-more":"enable","title-align":"left","title":"Recent News","caption":"","read-more-text":"Read More","read-more-link":"http://demo.goodlayers.com/infinite/blog","read-more-target":"_self","title-size":"43px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","blog-title-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"1280px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"gallery","value":{"id":"","gallery":[{"link-to":"none","custom-image":"","video-url":"","page-id":"762","custom-url":"","custom-link-target":"_self","id":"1889","thumbnail":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/06/banner-1-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"762","custom-url":"","custom-link-target":"_self","id":"1890","thumbnail":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/06/banner-2-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"762","custom-url":"","custom-link-target":"_self","id":"1891","thumbnail":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/06/banner-3-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"762","custom-url":"","custom-link-target":"_self","id":"1892","thumbnail":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/06/banner-4-150x150.png"},{"link-to":"none","custom-image":"","video-url":"","page-id":"762","custom-url":"","custom-link-target":"_self","id":"1893","thumbnail":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/06/banner-5-150x150.png"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"670px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"165px","right":"0px","bottom":"150px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"2202","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","skin":"White Text","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Get Contact","caption":"Keep In Touch","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"51px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1.5px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"15px","padding-bottom":"8px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"1px","divider-width":"105px","padding-bottom":"80px"}},{"template":"element","type":"social-network","value":{"id":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","text-align":"center","icon-size":"20px","icon-color":"","with-text":"enable","text-size":"15px","icon-space":"40px","padding-bottom":"80px"}},{"template":"element","type":"contact-form-7","value":{"id":"","cf7-id":"1319","padding-bottom":"0px"}}]}]';
				case 'home-main2':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#3a34af","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"-80px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"999","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2366","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Creative Web Design","caption":"Small Caption Here","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"12px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"14px","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"arrow_right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#394cc1","icon-color":"","text-hover-color":"#394cc1","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"999","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2367","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"User Friendly Tool","caption":"Small Caption Here","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"12px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"14px","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"arrow_right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#394cc1","icon-color":"","text-hover-color":"#394cc1","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"999","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2368","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"round","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"More Powerful Than Ever","caption":"Small Caption Here","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"20px","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"12px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"14px","text-color":"","padding-bottom":"0px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"arrow_right","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#394cc1","icon-color":"","text-hover-color":"#394cc1","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"960px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.2","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2369","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"180px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Infinite WordPress Theme","caption":"The most powerful theme on earth","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"43px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"17px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#2a2a38","title-link-hover-color":"","caption-color":"#656578","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"#86869d","padding-bottom":"10px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Explore More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"24px","bottom":"16px","left":"24px","settings":"unlink"},"border-radius":"3px","button-background":"gradient-v","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#3c39c1","background-hover-color":"","background-gradient-color":"#5754e1","border-color":"","border-hover-color":"","button-shadow-size":{"x":"","y":"12px","size":"22px","settings":"unlink"},"button-shadow-color":"#222b60","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"16px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"1400px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"#ffffff","container-shadow-size":{"x":"","y":"","size":"150px","settings":"unlink"},"container-shadow-color":"#191919","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"inner-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"156px","settings":"unlink"},"background-shadow-color":"#212121","background-shadow-opacity":"0.08","padding":{"top":"80px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"-80px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2371","title":"Web Development","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Conson</p>","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"13px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"inner-border","border-pre-spaces":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"border-width":{"top":"0px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"border-color":"#e0e0e0","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2372","title":"Excellent Support","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Conson</p>","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"13px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"24px","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2373","title":"Powerful Framework","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Conson</p>","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"13px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"","right":"","bottom":"25px","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2374","title":"Time Saving","caption":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Conson</p>","read-more-text":"Learn More","read-more-link":"#","style":"center_icon-top","icon-size":"30px","title-size":"19px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"13px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","icon-color":"","icon-background":"","background-color":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2377","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"gradient-v","background-extending":"left","background-color":"#0a0a0a","background-color-opacity":"0.7","background-gradient-color":"#0a0a0a","background-gradient-color-opacity":"0.2","background-image":"","background-image-style":"repeat-y","background-image-position":"top-right","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"128px","right":"60px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Purple section 1"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"icon_clock_alt","icon-style":"normal","image":"2381","title":"Get Inspired","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","title-size":"20px","title-font-weight":"800","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"5px","right":"28px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"icon_clock_alt","icon-style":"normal","image":"2382","title":"Be Creative","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","title-size":"20px","title-font-weight":"800","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"5px","right":"30px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"icon_clock_alt","icon-style":"normal","image":"2383","title":"Be Socialized","caption":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet.</p>","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","title-size":"20px","title-font-weight":"800","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","content-size":"14px","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","icon-color":"#ffffff","icon-background":"","background-color":"","media-margin":{"top":"5px","right":"34px","bottom":"","left":""},"title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"153px","right":"0px","bottom":"0px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Divider White Text"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"GoodLayers Page Builder","caption":"Sections and wrapper can be manage easily","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"#bfbdff","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"","text-color":"","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Find More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"33px","bottom":"14px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2926b9","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#fcfcff","background-hover-color":"","background-gradient-color":"#bfc1f8","border-color":"","border-hover-color":"","button-shadow-size":{"x":"","y":"12px","size":"30px","settings":"unlink"},"button-shadow-color":"#202149","button-shadow-opacity":"0.3","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"800","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f4f4f4","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Portfolio"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Works","caption":"A wonderful serenity has taken possession of my entire soul, like these<br/> sweet mornings of spring which I enjoy with my whole.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"15px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"20px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"8","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","view-all-works-button":"enable","view-all-works-text":"View All Works","view-all-works-link":"http://demo.goodlayers.com/infinite/homepages/main2/portfolio-3-columns-with-frame/","portfolio-style":"grid2","portfolio-grid-text-align":"center","portfolio-grid-style":"with-frame","portfolio-frame-opacity":"1","enable-portfolio-tag":"enable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"icon","column-size":"20","thumbnail-size":"Portfolio Thumbnail","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"disable","layout":"carousel","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation","carousel-bullet-style":"default","excerpt":"none","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"none","portfolio-title-font-size":"18px","portfolio-title-font-weight":"800","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-tag-font-style":"default","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-title-bottom-margin":"","padding-bottom":"0px","frame-shadow-color":"","frame-shadow-opacity":"0.2","overlay-color":"","overlay-opacity":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"View More Works","read-more-link":"http://demo.goodlayers.com/infinite/portfolio","read-more-target":"_self","title-size":"43px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2384","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.2","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"140px","right":"100px","bottom":"100px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Blue Divider"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Incredible Layouts","caption":"Limitless possibilities create","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-angle-right","icon-hover":"","title":"Full wrapper and sidebar wrapper","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Columns wrappers","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"More than 40 element items","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Many pre-built templates","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#bab8f6","icon-background-color":"","content-color":"#bab8f6","border-color":"","icon-size":"16px","content-size":"16px","icon-right-margin":"","list-bottom-margin":"7px","padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"15px","text-color":"#ffffff","padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"fadeInLeft","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f1f0f0","background-image":"2391","background-image-style":"cover","background-image-position":"center-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"400px","hide-this-wrapper-in":"mobile","animation":"fadeInRight","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"disable","background-type":"image","background-extending":"none","background-color":"#f1f0f0","background-image":"2411","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"100px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"145px","right":"100px","bottom":"110px","left":"100px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Power Elite Author","caption":"Be wise and choose","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"46px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"#515151","caption-spaces":"5px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are the top author of Themeforest, Power Elite Author. There are not much authors who hit power eilite level and with 5 years of expereinces. We know what exactly you want. We promise to deliver the best products with great after sales support and we won’t let you down.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"15px","text-color":"#707070","padding-bottom":"15px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-angle-right","icon-hover":"","title":"Over 120,000 Sales","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"More than 50 WordPress Themes","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Dedicated Support Team","link-url":""}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#333333","icon-background-color":"","content-color":"#848484","border-color":"","icon-size":"16px","content-size":"16px","icon-right-margin":"","list-bottom-margin":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#ffffff","background-gradient-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"74px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.07","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"0px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"","padding":{"top":"100px","right":"90px","bottom":"80px","left":"90px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We are trusted by more than 5,000 clients","caption":"Did you know that","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"42px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"19px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"10px","media-margin":{"top":"30px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"","padding-bottom":"16px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Explore More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"14px","right":"24px","bottom":"16px","left":"24px","settings":"unlink"},"border-radius":"3px","button-background":"gradient-v","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#3c39c1","background-hover-color":"","background-gradient-color":"#5754e1","border-color":"","border-hover-color":"","button-shadow-size":{"x":"","y":"12px","size":"22px","settings":"unlink"},"button-shadow-color":"#222b60","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"16px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"half-height","centering-sync-height-content":"enable","background-type":"html5-video","background-extending":"none","background-color":"#3740b0","background-image":"5496","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/video-bg.mp4","background-video-url-webm":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/video-bg.webm","background-video-url-ogg":"","background-video-image":"2458","background-pattern":"pattern-1","background-opacity":"0.7","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2399","background-image-style":"repeat-x","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"135px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What makes us the best?","caption":"among others","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"70px"}},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"99","animation-time":"4000","suffix":"%","divider":"disable","bottom-text":"","top-icon-size":"30px","top-text-size":"16px","number-size":"70px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Percent of customers who satisfy with our products.</p>","text-align":"center","apply-the-content-filter":"disable","font-size":"15px","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2395","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"187","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"","top-icon-size":"30px","top-text-size":"16px","number-size":"70px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Projects we recently delivered to customers</p>","text-align":"center","apply-the-content-filter":"disable","font-size":"15px","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2396","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"24","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"","top-icon-size":"30px","top-text-size":"16px","number-size":"70px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Hours we provide after sale supporter</p>","text-align":"center","apply-the-content-filter":"disable","font-size":"15px","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2397","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"16","animation-time":"4000","suffix":"","divider":"disable","bottom-text":"","top-icon-size":"30px","top-text-size":"16px","number-size":"70px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"","bottom-text-transform":"none","padding-bottom":"0px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Offices in all region across the world</p>","text-align":"center","apply-the-content-filter":"disable","font-size":"15px","text-color":"","padding-bottom":"10px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"2398","thumbnail-size":"full","link-to":"lb-full-image","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color":"","background-image":"2400","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"mobile","animation":"fadeInUp","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-80px","right":"0px","bottom":"-200px","left":"-300px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2401","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"2127","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","enable-caption":"disable","max-width":"","alignment":"left","enable-shadow":"disable","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","background-filter":"none","background-blur-size":"","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"160px","right":"90px","bottom":"100px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Infinite’s <br/>Admin Panel","caption":"Hundreds Options From","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"60px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"20px","caption-font-weight":"300","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"5px","padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with.</p>","text-align":"left","apply-the-content-filter":"disable","font-size":"16px","text-color":"#d3d3d3","padding-bottom":"15px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"icon":"fa fa-angle-right","icon-hover":"","title":"Select Header Styles","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Full/Boxes Layout","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Sidebar Width","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Social Media Sharing","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Font Selector","link-url":""},{"icon":"fa fa-angle-right","icon-hover":"","title":"Color Pickers","link-url":""}],"columns":"30","enable-divider":"disable","icon-background":"none","icon-color":"#ffffff","icon-background-color":"","content-color":"#ffffff","border-color":"","icon-size":"16px","content-size":"16px","icon-right-margin":"","list-bottom-margin":"10px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInUp","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"135px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Testimonial","caption":"What they say","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"70px"}},{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Jane Doe","position":"Jounalist","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","image":"2402","image-img":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/testimonial-1.jpg","rating":""},{"title":"Anakin Sky","position":"First Pilot","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","image":"2403","image-img":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/testimonial-2.jpg","rating":""},{"title":"John Smith","position":"Co-Founder","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","image":"506","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-1.jpg","rating":""},{"title":"Sarah Lopez","position":"CFO, Apple","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","image":"508","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-3.jpg","rating":""},{"title":"Robert Kim","position":"Customer","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy.","image":"507","image-img":"http://demo.goodlayers.com/infinite/wp-content/uploads/2016/05/testimonial-2.jpg","rating":""}],"style":"left-2","column":"3","thumbnail-size":"thumbnail","enable-quote":"enable","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-nav-style":"default","carousel-bullet-style":"cylinder","title-size":"43px","title-text-transform":"uppercase","title-font-weight":"","title-letter-spacing":"","caption-size":"16px","content-size":"16px","title-color":"","caption-color":"","quote-color":"#5d5bd0","content-color":"#5e5e5e","name-color":"","position-color":"#7a7a7a","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"gradient","background-color":"#3332b7","background-color-opacity":"1","background-gradient-color":"#4f4dc9","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Blog","caption":"New Stories From Us","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"#ffffff","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"70px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-gradient-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":"","tag":"","num-fetch":"8","prepend-sticky":"disable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-image-no-space","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-1","blog-full-alignment":"left","blog-image-alignment":"left","blog-list-with-frame":"disable","always-show-overlay-content":"enable","blog-image-thumbnail-overlay":"opacity","blog-image-thumbnail-overlay-opacity":"0.4","show-thumbnail":"enable","thumbnail-size":"Portfolio Thumbnail Portrait 2","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"15","layout":"fitrows","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-bullet-style":"default","item-size":"small","excerpt":"specify-number","excerpt-number":"55","blog-image-excerpt-number":"11","blog-date-feature":"enable","meta-option":["date"],"show-read-more":"enable","filterer-bottom-margin":"","blog-title-font-size":"24px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","frame-shadow-color":"","frame-shadow-opacity":"0.2","padding-bottom":"30px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"1280px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"enable","marquee-text":"CLIENTS<span style=\"font-weight: 900;\">CLIENTS</span>CLIENTS","marquee-position":"top","marquee-position-offset":"33px","marquee-speed":"20000","marquee-direction":"left","marquee-font-size":"175px","marquee-font-weight":"100","marquee-font-letter-spacing":"1px","marquee-text-color":"#f6f6f6","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"65px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"25px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"container-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"2410","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/banner-1-3-150x103.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2412","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/banner-2-150x103.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2413","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/banner-3-150x103.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2414","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/banner-4-150x103.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2415","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main2/wp-content/uploads/sites/25/2018/01/banner-5-150x103.png","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","grid-slider-navigation":"navigation","thumbnail-size":"full","slider-thumbnail-size":"medium","image-bottom-margin":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"gradient","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"#ededed","background-gradient-color-opacity":"1","background-image":"2416","background-image-style":"repeat-x","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Grey"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Meet Awesome Team","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"5px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"70px"}},{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"3","orderby":"date","order":"desc","text-align":"center","personnel-style":"grid-with-background","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"disable","enable-social-shortcode":"enable","column-size":"3","thumbnail-size":"Personnel Thumbnail 2","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","carousel":"disable","carousel-autoslide":"enable","carousel-navigation":"navigation","personnel-title-font-size":"21px","personnel-title-font-weight":"700","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"12px","personnel-position-font-weight":"","personnel-position-font-style":"normal","personnel-position-letter-spacing":"1px","personnel-position-text-transform":"uppercase","shadow-size":{"x":"","y":"","size":"80px","settings":"unlink"},"shadow-color":"#0a0a0a","shadow-opacity":"0.08","personnel-thumbnail-bottom-margin":"","personnel-title-bottom-margin":"","padding-bottom":"15px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"43px","title-letter-spacing":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Team","link-to":"custom-url","custom-image":"","video-url":"","button-link":"http://demo.goodlayers.com/infinite/homepages/main2/about-our-team/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#2926b9","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#fcfcff","background-hover-color":"","background-gradient-color":"#bfc1f8","border-color":"","border-hover-color":"","button-shadow-size":{"x":"","y":"","size":"30px","settings":"unlink"},"button-shadow-color":"#0a0a0a","button-shadow-opacity":"0.08","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"800","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","content-layout":"custom","max-width-wrapper":"","max-width":"670px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeIn","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2417","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-shadow-color":"","container-shadow-opacity":"0.2","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"165px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Contact Homepage"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Get Contact","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"30px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"","title-link-hover-color":"","caption-color":"","caption-spaces":"15px","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"37px","padding-bottom":"50px","icon-color":"","divider-color":""}},{"template":"element","type":"social-network","value":{"id":"","class":"","delicious":"","email":"#","deviantart":"","digg":"","facebook":"#","flickr":"","google-plus":"","lastfm":"","linkedin":"","pinterest":"","rss":"","skype":"#","stumbleupon":"","tumblr":"","twitter":"#","vimeo":"","youtube":"","dribbble":"","behance":"","instagram":"","snapchat":"","text-align":"center","icon-size":"20px","with-text":"enable","text-size":"15px","icon-color":"#ffffff","icon-space":"40px","padding-bottom":"55px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"1319","padding-bottom":"60px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Purchase Infinite Now!","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","icon-font-size":"30px","title-font-size":"39px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","caption-color":"","caption-spaces":"15px","padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Empower Your Business With Our Flagship WordPress Theme</p>","text-align":"center","apply-the-content-filter":"disable","font-size":"15px","text-color":"#bcbcbc","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Purchase Now!","link-to":"custom-url","custom-image":"","video-url":"","button-link":"http://1.envato.market/c/300702/275988/4415?u=https%3A%2F%2Fthemeforest.net%2Fitem%2Finfinite-responsive-multipurpose-wordpress-theme%2F16869357%3Flicense%3Dregular%26open_purchase_for_item_id%3D16869357%26purchasable%3Dsource","button-link-target":"_blank","icon-position":"none","icon":"fa fa-gear","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#7141f9","background-hover-color":"#363afd","background-gradient-color":"#363afd","border-color":"","border-hover-color":"","button-shadow-size":{"x":"","y":"16px","size":"57px","settings":"unlink"},"button-shadow-color":"#0a0a0a","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"15px","text-font-weight":"800","text-letter-spacing":"0px","text-transform":"none","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]';
				case 'home-main3':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"1320px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"-185px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"999","full-height":"disable","decrease-height":"0px","sync-height":"height1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"0px","b-right":"0px","b-left":"5px","settings":"unlink"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"40px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.06","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"52px","right":"35px","bottom":"20px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"25px","bottom":"","left":"25px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"new technology"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2566","character":"","title":"New Technology","caption":"","caption-position":"bottom","content":"<p>Bring your website to he ntext level with Infinite. One of the most powerful WordPress Theme on earth!</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","caption-font-weight":"","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"15px","read-more-font-weight":"400","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"#222222","icon-background":"#969696","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"999","full-height":"disable","decrease-height":"0px","sync-height":"height1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"5px","t-right":"0px","b-right":"0px","b-left":"5px","settings":"unlink"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"40px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.06","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"52px","right":"35px","bottom":"20px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"25px","bottom":"","left":"25px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"new technology"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2567","character":"","title":"High Standard Coding","caption":"","caption-position":"bottom","content":"<p>Bring your website to he ntext level with Infinite. One of the most powerful WordPress Theme on earth!</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","caption-font-weight":"","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"15px","read-more-font-weight":"400","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"#222222","icon-background":"#969696","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"999","full-height":"disable","decrease-height":"0px","sync-height":"height1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"0px","t-right":"5px","b-right":"5px","b-left":"0px","settings":"unlink"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"40px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.06","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"52px","right":"35px","bottom":"20px","left":"35px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"25px","bottom":"","left":"25px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"new technology"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2568","character":"","title":"Full of Options","caption":"","caption-position":"bottom","content":"<p>Bring your website to he ntext level with Infinite. One of the most powerful WordPress Theme on earth!</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-top","icon-size":"30px","title-size":"18px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"none","caption-size":"15px","caption-font-weight":"","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"15px","read-more-font-weight":"400","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"#222222","icon-background":"#969696","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"15px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2570","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"30px","divider-width":"4px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#dbdbdb"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"The most powerful theme on earth","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"3px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ff5443","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"900px","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast.</p>","text-align":"center","apply-the-content-filter":"enable","enable-p-space":"enable","font-size":"24px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#333a61","padding-bottom":"10px"}}]},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We provide complete solutions to our clients so they can focus their core business</p>","text-align":"center","apply-the-content-filter":"enable","enable-p-space":"enable","font-size":"17px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#919191","padding-bottom":"30px"}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height2","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Incredible Layouts","caption":"Limitless possibilities create\n","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"38px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#222d71","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#bfbfbf","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Full wrapper and sidebar wrapper","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Columns wrappers","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"More than 40 element items","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"icon_check_alt2","title":"Many pre-built templates","caption":"","link-url":"","link-target":"_self"}],"columns":"60","enable-divider":"disable","icon-background":"none","icon-color":"#353535","icon-background-color":"","content-color":"#353535","caption-color":"","border-color":"","icon-size":"14px","content-size":"17px","content-font-weight":"400","content-text-transform":"none","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"","icon-right-margin":"","list-bottom-margin":"10px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Bring your website to he ntext level with Infinite. One of the most powerful WordPress Theme on earth!</p>","text-align":"left","apply-the-content-filter":"enable","enable-p-space":"enable","font-size":"","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","text-color":"#969696","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ff5443","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":{"x":"7px","y":"0px","size":"18px","settings":"unlink"},"button-shadow-color":"ff5e4e","button-shadow-opacity":"0.65","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"600","text-letter-spacing":"","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height2","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2569","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"none","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"enable","background-shadow-size":{"x":"0px","y":"0px","size":"40px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.1","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"10px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height3","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2557","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height3","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"","bottom":"50px","left":"40px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Power Elite Author","caption":"Be wise and choose","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"38px","mobile-title-font-size":"","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#ff5443","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#bfbfbf","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"","title":"Over 140,000 Sales","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"","title":"More than 50 WordPress Themes","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"","title":"Dedicated Support Team","caption":"","link-url":"","link-target":"_self"}],"columns":"60","align":"left","enable-divider":"disable","icon-background":"none","icon-color":"#353535","icon-background-color":"","content-color":"#353535","caption-color":"","border-color":"","icon-size":"14px","content-size":"17px","content-font-weight":"400","content-text-transform":"none","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"7px","icon-right-margin":"","list-bottom-margin":"12px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are the top author of Themeforest, Power Elite Author. There are not much authors who hit power eilite level and with 5 years of expereinces. We know what exactly you want. We promise to deliver the best products with great after sales support and we won’t let you down.</p>","text-align":"left","apply-the-content-filter":"enable","enable-p-space":"enable","font-size":"15px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#969696","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2865","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height idea","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"creative color"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2521","character":"","title":"Creative Web Design","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"17px","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"#ff5443","icon-background":"#878ba5","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height idea","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"creative color"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2523","character":"","title":"User Friendly Tool","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"17px","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"#ff5443","icon-background":"#878ba5","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height idea","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"creative color"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2522","character":"","title":"Web Development","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"17px","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"#ff5443","icon-background":"#878ba5","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height idea","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"creative color"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2520","character":"","title":"Get Inspired","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"17px","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"#ff5443","icon-background":"#878ba5","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height idea","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"creative color"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2525","character":"","title":"Be Creative","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"17px","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"#ff5443","icon-background":"#878ba5","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height idea","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"creative color"},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2524","character":"","title":"Be Socialized","caption":"","caption-position":"bottom","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","icon-size":"30px","title-size":"17px","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"14px","caption-font-weight":"","caption-font-style":"default","caption-text-transform":"uppercase","content-size":"15px","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"#ff5443","icon-background":"#878ba5","background-color":"","media-margin":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2871","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"counter"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height ss","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Recent Works","caption":"How good are we?","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1c1c1c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#bfbfbf","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height ss","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"20px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/infinite/homepages/main3/portfolio-3-columns-with-frame/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"right","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"enable","border-width":{"top":"0px","right":"0px","bottom":"1px","left":"0px","settings":"unlink"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ff5443","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#ff5443","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"","text-transform":"none","icon-size":"","button2-left-margin":"","item-top-margin":"-5px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"your create"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","num-fetch":"5","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"grid","portfolio-grid-text-align":"center","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-title":"enable","enable-portfolio-tag":"enable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"icon","column-size":"20","thumbnail-size":"Personnel Square","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-bullet-style":"cylinder","excerpt":"none","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"uppercase","portfolio-title-font-size":"19px","portfolio-title-font-weight":"600","portfolio-title-letter-spacing":"0px","portfolio-title-text-transform":"none","portfolio-tag-font-style":"default","portfolio-hover-title-font-size":"","portfolio-hover-title-font-weight":"","portfolio-hover-title-letter-spacing":"","portfolio-hover-title-text-transform":"uppercase","filterer-bottom-margin":"","portfolio-frame-padding":"","portfolio-border-radius":"7px","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"10px","pagination-top-margin":"","padding-bottom":"30px","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","overlay-color":"","overlay-opacity":"","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"0","end-number":"99","animation-time":"","suffix":"%","divider":"disable","bottom-text":"Customer’s Satification","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"46px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"0","end-number":"342","animation-time":"","suffix":"","divider":"disable","bottom-text":"Delivered Projects","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"46px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"0","end-number":"24","animation-time":"","suffix":"","divider":"disable","bottom-text":"Support Hours","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"46px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","prefix":"","start-number":"0","end-number":"22","animation-time":"","suffix":"","divider":"disable","bottom-text":"Offices Across The Region","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"46px","number-font-weight":"700","bottom-text-size":"16px","bottom-text-font-weight":"400","bottom-text-transform":"none","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2545","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"330px","right":"0px","bottom":"337px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"1280px","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2872","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":{"t-left":"","t-right":"","b-right":"","b-left":"","settings":"link"},"container-shadow-size":{"x":"","y":"","size":"40px","settings":"unlink"},"container-shadow-color":"#0a0a0a","container-shadow-opacity":"0.08","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"","size":"40px","settings":"unlink"},"background-shadow-color":"#0a0a0a","background-shadow-opacity":"0.08","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-120px","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height admin","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"40px","bottom":"60px","left":"25px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Powerful Admin Panel","caption":"Hundreds options with","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"32px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1c1c1c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#bfbfbf","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"16px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#959595","padding-bottom":"15px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"left","full-width-button":"disable","button-padding":{"top":"17px","right":"34px","bottom":"17px","left":"34px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ff5443","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":{"x":"","y":"","size":"18px","settings":"unlink"},"button-shadow-color":"#ff5443","button-shadow-opacity":"0.65","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"","icon-size":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height admin","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"170px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"","title":"Select Header Styles","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"","title":"Full/Boxes Layout","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"","title":"Sidebar Width","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"","title":"Social Media Sharing","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"","title":"Font Selector","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon_check_alt2","icon-hover":"","title":"Color Pickers","caption":"","link-url":"","link-target":"_self"}],"columns":"30","align":"left","enable-divider":"disable","icon-background":"none","icon-color":"#ff5443","icon-background-color":"","content-color":"#ff5443","caption-color":"","border-color":"","icon-size":"15px","content-size":"15px","content-font-weight":"400","content-text-transform":"none","content-letter-spacing":"","caption-size":"15px","caption-font-weight":"400","caption-text-transform":"none","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"5px","icon-right-margin":"","list-bottom-margin":"12px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"50px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height admin1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"30px","right":"20px","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Grey Bullet"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Testimonial","caption":"What they say","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"31px","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"12px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#606480","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#bfbfbf","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"John Smith","position":"Jounalist, London","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear.","image":"2663","image-img":"https://demo.goodlayers.com/infinite/homepages/main3/wp-content/uploads/sites/27/2016/05/psinfinite5.jpg","rating":""},{"title":"James Doe","position":"Reviewer","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear.","image":"2662","image-img":"https://demo.goodlayers.com/infinite/homepages/main3/wp-content/uploads/sites/27/2016/05/psinfinite4.jpg","rating":""},{"title":"Helen Scott","position":"Accountant","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear.","image":"2660","image-img":"https://demo.goodlayers.com/infinite/homepages/main3/wp-content/uploads/sites/27/2016/05/psinfinite8.jpg","rating":""}],"style":"left-bg","with-frame":"disable","column":"1","thumbnail-size":"Personnel Square","enable-quote":"enable","quote-position":"bottom","carousel":"enable","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-nav-style":"default","carousel-bullet-style":"cylinder-left","title-size":"28px","title-text-transform":"none","title-font-weight":"","title-letter-spacing":"","content-size":"19px","name-size":"19px","name-font-weight":"600","name-letter-spacing":"0px","name-text-transform":"none","caption-size":"14px","position-font-style":"normal","title-color":"","caption-color":"","quote-color":"#d8d8d8","content-color":"#8c8c8c","name-color":"#ff5443","position-color":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height admin1","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2546","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2625","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-width":"0px","overlay-icon-size":"22","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2885","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height ss","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Recent News","caption":"Get update with us","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1c1c1c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#bfbfbf","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height ss","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"20px","right":"","bottom":"30px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/infinite/homepages/main3/blog-2-columns/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"right","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"enable","border-width":{"top":"0px","right":"0px","bottom":"1px","left":"0px","settings":"unlink"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ff5443","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#ff5443","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"600","text-letter-spacing":"","text-transform":"none","icon-size":"","button2-left-margin":"","item-top-margin":"-5px","padding-bottom":"0px"}}]},{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","num-fetch":"3","prepend-sticky":"disable","orderby":"title","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-3","blog-image-style":"style-1","blog-widget-style":"style-1","blog-full-alignment":"left","blog-image-alignment":"center","blog-list-with-frame":"disable","always-show-overlay-content":"disable","blog-image-thumbnail-overlay":"none","blog-image-thumbnail-overlay-opacity":"0.4","show-thumbnail":"enable","thumbnail-size":"Portfolio Thumbnail","enable-thumbnail-opacity-on-hover":"enable","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"fitrows","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation","carousel-bullet-style":"default","blog-widget-column":"60","blog-widget-bottom-divider":"disable","item-size":"small","excerpt":"specify-number","excerpt-number":"17","blog-image-excerpt-number":"0","blog-date-feature":"enable","meta-option":["date","author"],"show-read-more":"disable","filterer-bottom-margin":"","blog-title-font-size":"18px","blog-title-font-weight":"600","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","category-background-color":"","frame-shadow-size":{"x":"","y":"","size":"35px","settings":"unlink"},"frame-shadow-color":"#0a0a0a","frame-shadow-opacity":"0.08","blog-border-radius":"7px","blog-frame-padding":{"top":"40px","right":"30px","bottom":"40px","left":"40px","settings":"unlink"},"blog-image-overlay-content-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin-bottom":"","padding-bottom":"30px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"770px","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":"","tablet-margin":"","mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"30px","divider-width":"4px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#dbdbdb"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Cients really love us","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"3","title-font-uppercase":"enable","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ff5443","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","item-left-margin":"","caption-spaces":"0px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"24px","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","text-color":"#333a61","padding-bottom":"0px"}}]},{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"2559","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main3/wp-content/uploads/sites/27/2019/03/key-vision1-150x120.png"},{"id":"2560","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main3/wp-content/uploads/sites/27/2019/03/key-vision2-150x120.png"},{"id":"2561","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main3/wp-content/uploads/sites/27/2019/03/key-vision3-150x120.png"},{"id":"2562","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main3/wp-content/uploads/sites/27/2019/03/key-vision4-150x120.png"},{"id":"2563","thumbnail":"https://demo.goodlayers.com/infinite/homepages/main3/wp-content/uploads/sites/27/2019/03/key-vision5-150x120.png"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid-no-space","max-slider-height":"500px","overlay":"none","show-caption":"disable","overlay-on-hover":"disable","column":"5","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","image-bottom-margin":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2879","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.05","overflow":"visible","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"20px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Meet The Team","caption":"only professional here","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1c1c1c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#c1c1c1","item-left-margin":"","caption-spaces":"10px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"30px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#3646a6"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Personnel"},"items":[{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","num-fetch":"5","orderby":"date","order":"desc","text-align":"center","personnel-style":"grid-with-background","enable-position":"enable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"disable","enable-social-shortcode":"enable","column-size":"3","thumbnail-size":"Personnel Thumbnail","enable-thumbnail-opacity-on-hover":"disable","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","carousel":"enable","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-bullet-style":"cylinder","personnel-title-font-size":"19px","personnel-title-font-weight":"600","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"15px","personnel-position-font-weight":"400","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","shadow-size":{"x":"","y":"","size":"31px","settings":"unlink"},"shadow-color":"#000000","shadow-opacity":"0.07","personnel-border-radius":"7px","personnel-thumbnail-bottom-margin":"","personnel-modern-content-bottom":"","personnel-title-bottom-margin":"","padding-bottom":"30px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-style":"","caption-spaces":"","read-more-size":"14px","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"20px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Get Update With Us","caption":"Subscribe to newsletter","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","title-left-icon":"none","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"40px","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","caption-font-weight":"700","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1c1c1c","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#c1c1c1","item-left-margin":"","caption-spaces":"15px","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"555px","min-height":"","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Subscribe Form"},"items":[{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"rectangle","shadow-size":{"x":"","y":"","size":"40px","settings":"unlink"},"shadow-color":"#0a0a0a","shadow-opacity":"0.08","padding-bottom":"30px"}}]}]}]';
				case 'home-main4':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#7985f0","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","z-index":"","padding-bottom":"0px"}},{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"bottom","shape":"mountains","custom-shape":"","custom-image":"","inverted":"disable","flip":"disable","vflip":"disable","opacity":"","color":"#ffffff","width":"","height":"130px","hide-this-item-in":"mobile","z-index":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"115px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Column SVC Infinite Main HP"},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Start growing with Infinite Software today","caption":"Powerful, not overpowering","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","title-font-family":"heading-font","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#b1b1b1","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"20px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"800px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>With tools to make every part of your process more human and a support team excited to help you, getting started with inbound has never been easier.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInUp","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"11px","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.1","padding":{"top":"0px","right":"20px","bottom":"40px","left":"20px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"3177","character":"","title":"Marketing","caption":"","caption-position":"bottom","content":"<p>SEO keyword rank monitoring – across multiple locations, languages and competitor websites.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","heading-tag":"h3","icon-size":"30px","title-size":"22px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-font-style":"default","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"-40px","right":"","bottom":"25px","left":""},"media-image-max-width":"80px","character-width":"","title-top-padding":"","title-bottom-margin":"30px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#a9b1bd","icon-color":"","text-hover-color":"#002e5b","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInDown","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"11px","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.1","padding":{"top":"0px","right":"20px","bottom":"40px","left":"20px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"3178","character":"","title":"Branding","caption":"","caption-position":"bottom","content":"<p>SEO keyword rank monitoring – across multiple locations, languages and competitor websites.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","heading-tag":"h3","icon-size":"30px","title-size":"22px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-font-style":"default","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"-40px","right":"","bottom":"25px","left":""},"media-image-max-width":"80px","character-width":"","title-top-padding":"","title-bottom-margin":"30px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#a9b1bd","icon-color":"","text-hover-color":"#002e5b","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInUp","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"8px","t-right":"8px","b-right":"8px","b-left":"8px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"11px","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.1","padding":{"top":"0px","right":"20px","bottom":"40px","left":"20px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"3179","character":"","title":"Web Design","caption":"","caption-position":"bottom","content":"<p>SEO keyword rank monitoring – across multiple locations, languages and competitor websites.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"center_icon-top","heading-tag":"h3","icon-size":"30px","title-size":"22px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-font-style":"default","title-letter-spacing":"","title-text-transform":"none","caption-size":"16px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"16px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"-40px","right":"","bottom":"25px","left":""},"media-image-max-width":"80px","character-width":"","title-top-padding":"","title-bottom-margin":"30px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Read More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#a9b1bd","icon-color":"","text-hover-color":"#002e5b","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"All Services","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"19px","right":"37px","bottom":"19px","left":"37px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#002e5b","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#70ebe6","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"500","text-letter-spacing":"1px","text-transform":"","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f6fbff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"145px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"top","shape":"waves","custom-shape":"","custom-image":"","inverted":"disable","flip":"enable","vflip":"disable","opacity":"","color":"#ffffff","width":"","height":"70px","hide-this-item-in":"none","z-index":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInLeft","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-57px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"3191","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"3137","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","mobile-alignment":"","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInRight","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"105px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Marketing that gets great results","caption":"Visual identity, development, and Digital Experiences","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","title-font-family":"heading-font","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#b1b1b1","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We help our clients achieve their goals through our expertise in design, technology, content, and marketing. We work closely with clients to understand their customers and to create experiences that deepen those relationships.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"About Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"left","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"19px","right":"53px","bottom":"19px","left":"53px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#002e5b","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#70ebe6","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"500","text-letter-spacing":"1px","text-transform":"","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"bottom","shape":"waves","custom-shape":"","custom-image":"","inverted":"enable","flip":"enable","vflip":"disable","opacity":"","color":"#ffffff","width":"","height":"70px","hide-this-item-in":"none","z-index":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"3188","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"3228","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"200px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"70px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"A creative and digital marketing agency founded in New York","caption":"Boost your online presence with higher search rankings","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","title-font-family":"heading-font","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#b1b1b1","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"skill-bar","value":{"id":"","class":"","bar-size":"small","bar-type":"round","tabs":[{"heading-text":"Marketing","icon":"","percent":"90","bar-text":""},{"heading-text":"Strategy","icon":"","percent":"70","bar-text":""},{"heading-text":"Branding","icon":"","percent":"80","bar-text":""},{"heading-text":"UX Design","icon":"","percent":"90","bar-text":""}],"heading-text-color":"#002e5b","icon-color":"","percent-color":"#002e5b","bar-filled-color":"#70ebe6","bar-filled-gradient-color":"","bar-background-color":"#f3f3f3","title-font-size":"20px","title-font-style":"normal","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","right-text-font-size":"20px","right-text-font-style":"normal","right-text-font-weight":"600","right-text-letter-spacing":"0px","right-text-text-transform":"none","space-between-item":"22px","padding-bottom":"20px"}}]},{"template":"wrapper","type":"column","column":"30"}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f6fbff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"3217","background-image-top-offset":"40px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"160px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Counter Infinite HP"},"items":[{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"top","shape":"waves","custom-shape":"","custom-image":"","inverted":"disable","flip":"enable","vflip":"disable","opacity":"","color":"#ffffff","width":"","height":"70px","hide-this-item-in":"none","z-index":""}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"710px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We help clients solve business problems ","caption":"Powerful, not overpowering","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","title-font-family":"heading-font","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#b1b1b1","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"13px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>With tools to make every part of your process more human and a support team excited to help you, getting started with inbound has never been easier.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"-100px","left":"0px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":"","tag":"","relation":"or","num-fetch":"6","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"load-more","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"modern","portfolio-modern2-with-space":"enable","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-title":"enable","enable-portfolio-tag":"enable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title","thumbnail-button1-text":"","thumbnail-button1-background":"","thumbnail-button1-text-hover":"","thumbnail-button1-background-hover":"","thumbnail-button2-text":"","thumbnail-button2-background":"","thumbnail-button2-text-hover":"","thumbnail-button2-background-hover":"","thumbnail-button-padding":"","thumbnail-button-border-radius":"","thumbnail-button-font-size":"","thumbnail-button-font-weight":"","thumbnail-button-letter-spacing":"","thumbnail-button-text-transform":"none","column-size":"20","thumbnail-size":"Portfolio Thumbnail Portrait 2","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"fitrows","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-start-at":"","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":"","carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"default","carousel-bullet-top-margin":"","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"uppercase","portfolio-title-font-size":"","portfolio-title-font-weight":"","portfolio-title-letter-spacing":"","portfolio-title-text-transform":"uppercase","portfolio-tag-font-size":"","portfolio-tag-font-style":"","portfolio-tag-text-transform":"","portfolio-hover-title-font-size":"26px","portfolio-hover-title-font-weight":"400","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-top-margin":"","filterer-bottom-margin":"","portfolio-frame-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"portfolio-border-radius":"8px","portfolio-frame-border-size":"","portfolio-frame-border-color":"","portfolio-frame-hover-border-color":"","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"","pagination-top-margin":"","padding-bottom":"30px","overlay-color":"#7884f0","overlay-opacity":"0.9","overlay-title-color":"","overlay-info-color":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"bottom","shape":"waves","custom-shape":"","custom-image":"","inverted":"disable","flip":"disable","vflip":"disable","opacity":"","color":"#ffffff","width":"","height":"100px","hide-this-item-in":"none","z-index":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Counter Infinite HP"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInUp","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"137","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Completed Projects","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","number-font-style":"normal","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-font-style":"normal","bottom-text-transform":"none","title-bottom-margin":"","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInDown","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"120","animation-time":"","suffix":"","divider":"disable","bottom-text":"Happy Customers","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","number-font-style":"normal","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-font-style":"normal","bottom-text-transform":"none","title-bottom-margin":"","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInUp","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"11","animation-time":"","suffix":"k","divider":"disable","bottom-text":"Working Hours","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","number-font-style":"normal","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-font-style":"normal","bottom-text-transform":"none","title-bottom-margin":"","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInDown","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"23","animation-time":"","suffix":"","divider":"disable","bottom-text":"Awards Winning","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"52px","number-font-weight":"600","number-font-style":"normal","bottom-text-size":"20px","bottom-text-font-weight":"500","bottom-text-font-style":"normal","bottom-text-transform":"none","title-bottom-margin":"","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f6fbff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Increase your productivity with digital tools created for you","caption":"Default sample caption text","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#b1b1b1","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"20px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"63px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Standard old school website doesn\'t work anymore. To have great results in sales we may need to set additional websites for you (you will keep old one up and running) to ensure they are designed to push people to buy your products or services (not only display the information).</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"191px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"15px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>It doesn\'t matter if you offering services or products. You need someone who pushes people through the process, no matter if your goal is to get the people on the phone, send your request or buy on the spot.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"3218","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"3159","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"230px","alignment":"left","mobile-alignment":"","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Ernest Smith","caption":"CEO & Founder","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#adadad","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f6fbff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"3219","background-image-top-offset":"25px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"420px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"-330px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"personnel","value":{"id":"","class":"","category":"","personnels":"","num-fetch":"6","filterer":"disable","filterer-color":"","orderby":"date","order":"desc","personnel-style":"grid-with-background","text-align":"center","always-show-overlay-content":"enable","enable-title":"enable","enable-position":"enable","widget-enable-position":"disable","disable-link":"disable","enable-divider":"disable","divider-skewx":"","enable-excerpt":"disable","enable-social-shortcode":"enable","column-size":"3","thumbnail-size":"Personnel Square","enable-thumbnail-opacity-on-hover":"disable","initial-thumbnail-opacity":"","thumbnail-opacity":"","thumbnail-opacity-background":"","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","hover-content":"center","enable-hover-title":"disable","enable-hover-social":"round-border","social-hover-color":"","enable-hover-excerpt":"disable","carousel":"enable","carousel-start-at":"","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"round5 gdlr-core-border-color-bullet","carousel-bullet-top-margin":"50px","personnel-title-font-size":"20px","personnel-title-font-weight":"600","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"16px","personnel-position-font-weight":"400","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"shadow-size":{"x":"","y":"15px","size":"30px","settings":"unlink"},"shadow-color":"#030f27","shadow-opacity":"0.15","personnel-border-radius":"8px","personnel-thumbnail-bottom-margin":"","personnel-modern-content-bottom":"","personnel-title-bottom-margin":"","list-margin-bottom":"","hover-social-top-margin":"","hover-social-bottom-margin":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"55px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"70px","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"1px","divider-width":"","divider-border-radius":"","divider-skewx":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":""}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInLeft","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-49px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"3194","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"","page-id":"3159","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom-image","overlay-icon-style":"always-show-2","overlay-icon":"fa fa-android","overlay-image":"3220","enable-caption":"disable","max-width":"","alignment":"center","mobile-alignment":"","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"custom","overlay-icon-size-custom":"105px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInRight","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"A digital experience company","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","title-font-family":"heading-font","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Branding","caption":"Default We are a global creative network in advertising, technology\nand entertainment. We solve problems by fusing creativity, innovation, strategy, and craft. caption text","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"20px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#373737","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Branding","caption":"Default We are a global creative network in advertising, technology\nand entertainment. We solve problems by fusing creativity, innovation, strategy, and craft. caption text","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"20px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#373737","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"3198","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"80px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"800px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Setting up your website only takes a few minutes","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"52px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"730px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Subscribe Form"},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are a remote-first team with offices in New York City and Los Angeles. Tell us about your project!</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"22px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#ffffff","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"50px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"curve","shadow-size":"","shadow-color":"","shadow-opacity":"0.2","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"80px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Find out the latest marketing news","caption":"Latest transportation news","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","title-font-family":"heading-font","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#b1b1b1","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"70px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInUp","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Dark Blue Title"},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":"","relation":"or","num-fetch":"6","prepend-sticky":"disable","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-4-left-button","blog-column-text-align":"left","blog-image-style":"style-1","blog-image-5-background":"","blog-widget-style":"style-1","blog-widget-with-feature":"disable","blog-full-alignment":"left","blog-image-alignment":"center","blog-list-with-frame":"disable","always-show-overlay-content":"disable","blog-image-thumbnail-overlay":"none","blog-image-thumbnail-overlay-opacity":"0.4","blog-image-thumbnail-overlay-color":"#000000","blog-column-thumbnail-overlay-opacity":"0.4","blog-column-thumbnail-overlay-color":"#000000","show-thumbnail":"enable","thumbnail-size":"Blog Column Thumbnail","enable-thumbnail-opacity-on-hover":"enable","blog-image-initial-opacity":"","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-item-margin":"","carousel-overflow":"","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation-outer","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"icon-arrow-left","carousel-navigation-right-icon":"icon-arrow-right","carousel-navigation-icon-color":"#b2b2b2","carousel-navigation-icon-hover-color":"#7985f0","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-size":"20px","carousel-navigation-margin":"23px","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"-35px","carousel-bullet-style":"round5 gdlr-core-border-color-bullet","carousel-bullet-top-margin":"","blog-widget-column":"60","blog-widget-bottom-divider":"disable","item-size":"small","excerpt":"specify-number","excerpt-number":"0","blog-image-excerpt-number":"0","blog-date-feature":"enable","meta-option":["date","tag"],"show-read-more":"text","read-more-button-text":"","filterer-bottom-margin":"","blog-title-font-size":"22px","blog-title-font-style":"normal","blog-title-font-weight":"500","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","category-background-color":"","thumbnail-date-background-color":"","thumbnail-date-color":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"12px","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.1","blog-border-radius":"8px","blog-frame-border-size":"1px","blog-frame-border-color":"#e7e7e7","blog-frame-hover-border-color":"#ffffff","blog-frame-padding":{"top":"25px","right":"","bottom":"10px","left":"","settings":"unlink"},"blog-image-overlay-content-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin-bottom":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Visit Blog","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/infinite/homepages/main4/blog-full-left-aligned/","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"20px","right":"43px","bottom":"20px","left":"43px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#777777","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ebeaea","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f6fbff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"What our clients say about us","caption":"Our Client Testimonials","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","title-font-family":"heading-font","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#b1b1b1","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"70px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Andrea Smith ","position":"Co-Founder & CEO","content":"<p>\"The marketing strategy has been a critical part of the organization’s growth and increasing visibility in our area. Our increased traffic and reach has exceeded our expectations.”</p>","image":"3199","image-img":"https://demo.goodlayers.com/infinite/homepages/main4/wp-content/uploads/sites/38/2022/03/b02.jpg","rating":"10"},{"title":"Christine White","position":" Co-Founder & CEO","content":"<p>\"The marketing strategy has been a critical part of the organization’s growth and increasing visibility in our area. Our increased traffic and reach has exceeded our expectations.”</p>","image":"3204","image-img":"https://demo.goodlayers.com/infinite/homepages/main4/wp-content/uploads/sites/38/2022/03/P02.jpg","rating":"10"},{"title":"Ernest Brown","position":" Co-Founder & CEO","content":"<p>\"The marketing strategy has been a critical part of the organization’s growth and increasing visibility in our area. Our increased traffic and reach has exceeded our expectations.”</p>","image":"3200","image-img":"https://demo.goodlayers.com/infinite/homepages/main4/wp-content/uploads/sites/38/2022/03/b8.jpg","rating":"10"},{"title":"Nicole Moore","position":" Co-Founder & CEO","content":"<p>\"The marketing strategy has been a critical part of the organization’s growth and increasing visibility in our area. Our increased traffic and reach has exceeded our expectations.”</p>","image":"3205","image-img":"https://demo.goodlayers.com/infinite/homepages/main4/wp-content/uploads/sites/38/2022/03/P03.jpg","rating":"10"},{"title":"Vincent Garcia","position":" Co-Founder & CEO","content":"<p>\"The marketing strategy has been a critical part of the organization’s growth and increasing visibility in our area. Our increased traffic and reach has exceeded our expectations.”</p>","image":"3201","image-img":"https://demo.goodlayers.com/infinite/homepages/main4/wp-content/uploads/sites/38/2022/03/b1.jpg","rating":"10"},{"title":"Matthew Hernandez","position":" Co-Founder & CEO","content":"<p>\"The marketing strategy has been a critical part of the organization’s growth and increasing visibility in our area. Our increased traffic and reach has exceeded our expectations.”</p>","image":"3207","image-img":"https://demo.goodlayers.com/infinite/homepages/main4/wp-content/uploads/sites/38/2022/03/M01.jpg","rating":"10"}],"style":"chat","content-top-padding":"0px","center-2-layout":"normal","chat-frame-background":"#ffffff","with-frame":"disable","column":"3","thumbnail-size":"thumbnail","enable-quote":"enable","quote-image":"","left-quote-position":"left","quote-position":"bottom","rating-position":"left","rating-top-margin":"","carousel":"enable","carousel-left-title":"","carousel-left-content":"","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation-outer","carousel-navigation-show-on-hover":"enable","carousel-navigation-align":"center","carousel-navigation-left-icon":"icon-arrow-left","carousel-navigation-right-icon":"icon-arrow-right","carousel-navigation-size":"20px","carousel-navigation-icon-color":"#9b9b9c","carousel-navigation-icon-hover-color":"#7985f0","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"-10px","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"-50px","carousel-nav-style":"default","carousel-bullet-style":"default","quote-size":"","quote-font-weight":"","quote-height":"","quote-top-margin":"","quote-bottom-margin":"","title-size":"28px","title-text-transform":"uppercase","title-font-weight":"","title-letter-spacing":"","content-size":"16px","mobile-content-size":"","content-line-height":"","content-font-style":"normal","content-font-weight":"","content-letter-spacing":"","name-size":"14px","name-font-weight":"500","name-font-style":"normal","name-letter-spacing":"","name-text-transform":"","caption-size":"","position-font-style":"normal","position-font-weight":"","rating-font-size":"","frame-border-size":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-border-color":"","frame-hover-border-color":"","frame-border-radius":"","frame-border-radius2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"0px","frame-hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.1","title-color":"","caption-color":"","quote-color":"","content-color":"","name-color":"","position-color":"","star-rating-color":"","frame-background-color":"","hover-quote-color":"","hover-content-color":"","hover-name-color":"","hover-position-color":"","hover-star-rating-color":"","hover-frame-background-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"0px","carousel-bullet-top-margin":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#7985f0","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"3223","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"3229","background-image-style":"repeat-x","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInLeft","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-120px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"3224","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"3159","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","mobile-alignment":"","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInRight","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"White Text"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We design things scientifically and with empathy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","title-font-family":"heading-font","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#b1b1b1","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"3225","character":"","title":"Transformation","caption":"Digital transformations that put easy to use data-driven tools at their centre are more than twice as likely to succeed.","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"18px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"600","title-font-style":"normal","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"3226","character":"","title":"Efficiency","caption":"Digital transformations that put easy to use data-driven tools at their centre are more than twice as likely to succeed.","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"18px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"600","title-font-style":"normal","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"3227","character":"","title":"Growth","caption":"Digital transformations that put easy to use data-driven tools at their centre are more than twice as likely to succeed.","caption-position":"bottom","content":"","read-more-text":"","read-more-link":"","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"18px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"600","title-font-style":"normal","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"15px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":"","media-image-max-width":"","character-width":"","title-top-padding":"","title-bottom-margin":"","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Started","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"left","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"18px","right":"37px","bottom":"18px","left":"37px","settings":"unlink"},"border-radius":"4px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#002e5b","icon-color":"","text-hover-color":"#002e5b","icon-hover-color":"","background-color":"#70ebe6","background-hover-color":"#ffffff","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"","text-font-style":"normal","text-font-weight":"500","text-letter-spacing":"1px","text-transform":"","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]}]';
				case 'home-construction':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","z-index":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"enable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"-150px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"container-border-radius":{"t-left":"","t-right":"","b-right":"","b-left":"","settings":"unlink"},"container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"9","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInUp","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"0px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"border-color":"#e7e7e7","hover-border-color":"#ff5e14","border-style":"solid","background-shadow-size":{"x":"","y":"30px","size":"50px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"","enable-move-up-shadow-effect":"enable","move-up-effect-length":"11px","frame-hover-shadow-size":{"x":"","y":"30px","size":"50px","settings":"unlink"},"frame-hover-shadow-color":"#00235a","frame-hover-shadow-opacity":"0.3","padding":{"top":"35px","right":"20px","bottom":"40px","left":"20px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2429","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2394","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"80px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"20px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Construction","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"22px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Offering expertise and guidance in support of mining and metals contribution to sustainable development.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInDown","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"0px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"border-color":"#e7e7e7","hover-border-color":"#ff5e14","border-style":"solid","background-shadow-size":{"x":"","y":"30px","size":"50px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"","enable-move-up-shadow-effect":"enable","move-up-effect-length":"11px","frame-hover-shadow-size":{"x":"","y":"30px","size":"50px","settings":"unlink"},"frame-hover-shadow-color":"#00235a","frame-hover-shadow-opacity":"0.3","padding":{"top":"35px","right":"20px","bottom":"40px","left":"20px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2430","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2394","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"80px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"20px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Mining & Metals","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"22px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Offering expertise and guidance in support of mining and metals contribution to sustainable development.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"5px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInUp","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"0px","right":"0px","bottom":"5px","left":"0px","settings":"unlink"},"border-color":"#e7e7e7","hover-border-color":"#ff5e14","border-style":"solid","background-shadow-size":{"x":"","y":"30px","size":"50px","settings":"unlink"},"background-shadow-color":"","background-shadow-opacity":"","enable-move-up-shadow-effect":"enable","move-up-effect-length":"11px","frame-hover-shadow-size":{"x":"","y":"30px","size":"50px","settings":"unlink"},"frame-hover-shadow-color":"#00235a","frame-hover-shadow-opacity":"0.3","padding":{"top":"35px","right":"20px","bottom":"40px","left":"20px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2431","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2394","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"80px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"20px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Infrastructure ","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"22px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Offering expertise and guidance in support of mining and metals contribution to sustainable development.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"5px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Safe, fair and sustainable construction industry","caption":"The Value of Minerals and Metals","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#777777","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"50px","divider-border-radius":"0px","divider-skewx":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"35px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#ff5e14"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"680px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We strengthen environmental and social performance and serve as a catalyst for change, enhancing mining’s contribution to society.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2480","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInLeft","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"40px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Infrastructure, industry & innovation","caption":"About Our Company","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"30px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#ff5e14","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"20px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Bringing together 28 mining and metals company members and over 35 national, regional and commodities association members, we strengthen environmental and social performance and serve as a catalyst for change, enhancing mining’s contribution to society.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"55px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"left","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"20px","right":"33px","bottom":"20px","left":"33px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ff5e14","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInRight","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"-60px","bottom":"0px","left":"-40px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2481","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2427","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","mobile-alignment":"","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"custom","max-width-wrapper":"","max-width":"1350px","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Trusted by forward-thinking construction &amp; engineering teams around the world</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"15px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"uppercase","tablet-font-size":"","mobile-font-size":"","text-color":"#002e5b","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"2420","thumbnail":"https://demo.goodlayers.com/infinite/homepages/construction/wp-content/uploads/sites/39/2022/03/logo01-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2421","thumbnail":"https://demo.goodlayers.com/infinite/homepages/construction/wp-content/uploads/sites/39/2022/03/logo02-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2422","thumbnail":"https://demo.goodlayers.com/infinite/homepages/construction/wp-content/uploads/sites/39/2022/03/logo03-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2423","thumbnail":"https://demo.goodlayers.com/infinite/homepages/construction/wp-content/uploads/sites/39/2022/03/logo04-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid-no-space","max-slider-height":"500px","slider-side-padding":"","slider-nav-style":"scroll","overlay":"none","icon-hover-style":"icon_zoom-in_alt","show-caption":"disable","overlay-on-hover":"disable","column":"4","layout":"fitrows","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-caption":"enable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","thumbnail-size":"full","slider-thumbnail-size":"medium","carousel-navigation":"navigation","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":"","carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"default","overlay-color":"","overlay-opacity":"200","border-radius":"","image-left-right-margin":"","image-bottom-margin":"","mobile-image-bottom-margin":"30px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2437","background-image-top-offset":"20px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"180px","right":"0px","bottom":"180px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Mineral Resource Development Specialists","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"22px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#ffffff","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"13px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"770px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We provide geological consulting, exploration management and contract geological services to the global mining and exploration industry.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"22px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#ffffff","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"60px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Contact Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"18px","right":"35px","bottom":"18px","left":"35px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ff5e14","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f8f8f8","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2485","background-image-top-offset":"100px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Global mining, metal & construction services","caption":"Global geology services","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#777777","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"19px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"50px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#ff5e14"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e8e8e8","hover-border-color":"#e8e8e8","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"0px","settings":"link"},"background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.1","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2482","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2427","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","mobile-alignment":"","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"disable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Exploration Services","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"22px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e8e8e8","hover-border-color":"#e8e8e8","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"0px","settings":"link"},"background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.1","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2483","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2427","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","mobile-alignment":"","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"disable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Construction Building","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"22px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e8e8e8","hover-border-color":"#e8e8e8","border-style":"solid","background-shadow-size":{"x":"0px","y":"0px","size":"0px","settings":"link"},"background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.1","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"15px","bottom":"0px","left":"15px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2484","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2427","custom-url":"","custom-link-target":"_self","overlay-icon-type":"default","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","mobile-alignment":"","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"disable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Contract Geologists","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"22px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"20px","right":"50px","bottom":"20px","left":"50px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#777777","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#e1e1e1","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInLeft","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2396","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"","bottom":"0px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2486","thumbnail-size":"full","z-index":"","link-to":"lb-video","custom-image":"","video-url":"https://www.youtube.com/watch?v=POqw0rIJe78","page-id":"2394","custom-url":"","custom-link-target":"_self","overlay-icon-type":"custom-image","overlay-icon-style":"always-show-2","overlay-icon":"fa fa-android","overlay-image":"2397","enable-caption":"disable","max-width":"","alignment":"center","mobile-alignment":"","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"custom","overlay-icon-size-custom":"105px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"80px","right":"50px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"50px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Infrastructure, industry & innovation","caption":"About Our Company","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"30px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#ff5e14","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Bringing together 28 mining and metals company members and over 35 national, regional and commodities association members, we strengthen environmental and social performance and serve as a catalyst for change, enhancing mining’s contribution to society.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"16px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"60px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2444","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"counter color"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInUp","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2440","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2427","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"50px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"137","animation-time":"","suffix":"+","divider":"disable","bottom-text":"Completed Projects","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","title-bottom-margin":"25px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInDown","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2441","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2427","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"53px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"1200","animation-time":"","suffix":"","divider":"disable","bottom-text":"Happy Customers","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","title-bottom-margin":"25px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInUp","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2442","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2427","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"50px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"11","animation-time":"","suffix":"k","divider":"disable","bottom-text":"Working Hours","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","title-bottom-margin":"25px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInDown","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2443","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2427","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"52px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","style":"bottom-caption","align":"center","prefix":"","start-number":"0","end-number":"23","animation-time":"","suffix":"","divider":"disable","bottom-text":"Awards Winning","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"42px","number-font-weight":"600","bottom-text-size":"22px","bottom-text-font-weight":"500","bottom-text-transform":"none","title-bottom-margin":"25px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#ffffff","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2488","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"toggle color"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"50px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Learn about the building materials we use","caption":"Frequently Asked Questions","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-skewx":"","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#777777","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"15px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"50px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#ff5e14"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"What kinds of architectural styles do you offer?","content":"<p>Just about any style you can think of. We don’t just work off a fixed set of floor plans, and we’re not limited to certain styles that we’ve done in the past. In fact, if you really want us to get excited about your home, ask us to build a home we’ve never done before!</p>"},{"head-text":"","title":"Why do you frame floating walls in the basement?","content":"<p>Just about any style you can think of. We don’t just work off a fixed set of floor plans, and we’re not limited to certain styles that we’ve done in the past. In fact, if you really want us to get excited about your home, ask us to build a home we’ve never done before!</p>"},{"head-text":"","title":"What are tap fees and how are they calculated?","content":"<p>Just about any style you can think of. We don’t just work off a fixed set of floor plans, and we’re not limited to certain styles that we’ve done in the past. In fact, if you really want us to get excited about your home, ask us to build a home we’ve never done before!</p>"},{"head-text":"","title":"How much do solar power systems cost?","content":"<p>Just about any style you can think of. We don’t just work off a fixed set of floor plans, and we’re not limited to certain styles that we’ve done in the past. In fact, if you really want us to get excited about your home, ask us to build a home we’ve never done before!</p>"}],"active":"","allow-closing-all-tabs":"enable","style":"background-title-icon","with-divider":"disable","align":"left","icon-position":"right","title-font-size":"18px","title-font-style":"normal","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","title-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"How do I get financing to build a custom home?","content":"<p>Great question! The easiest way, of course, is to pay cash (which some clients do). The next best way is to get a construction loan. If you have already been prequalified for a construction loan with a lender you trust, great! We’re happy to work with them.</p>"},{"head-text":"","title":"Can I save money by doing some of the work myself?","content":"<p>Great question! The easiest way, of course, is to pay cash (which some clients do). The next best way is to get a construction loan. If you have already been prequalified for a construction loan with a lender you trust, great! We’re happy to work with them.</p>"},{"head-text":"","title":"How does a construction loan work?","content":"<p>Great question! The easiest way, of course, is to pay cash (which some clients do). The next best way is to get a construction loan. If you have already been prequalified for a construction loan with a lender you trust, great! We’re happy to work with them.</p>"},{"head-text":"","title":"Do you sell log home kits?","content":"<p>Great question! The easiest way, of course, is to pay cash (which some clients do). The next best way is to get a construction loan. If you have already been prequalified for a construction loan with a lender you trust, great! We’re happy to work with them.</p>"}],"active":"","allow-closing-all-tabs":"enable","style":"background-title-icon","with-divider":"disable","align":"left","icon-position":"right","title-font-size":"18px","title-font-style":"normal","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","title-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2446","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"20px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"65px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Contact Details","caption":"Contact Us","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"1px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#f2f2f2","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"50px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"70px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#ff5e14"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"","icon-hover":"","title":"Office Address","caption":"Midtown Manhattan 112 W 34th St, NYC. US","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Our Telephones","caption":"<span style=\"color: #ff5e14;\"> (+1) 212-946-2707 </span> /  (+1) 212-946-2700","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"","icon-hover":"","title":"Our Emails","caption":"<span style=\"color: #ff5e14;\"> hello@Infinite.com </span> / sales@Infinite.com","link-url":"","link-target":"_self"}],"columns":"60","style":"style-1","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"","icon-background-color":"","content-color":"#cacaca","caption-color":"#ffffff","border-color":"","icon-size":"14px","content-size":"18px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"0px","caption-size":"18px","caption-font-weight":"400","caption-text-transform":"none","caption-letter-spacing":"0px","image-max-width":"","icon-top-margin":"","icon-right-margin":"","list-bottom-margin":"30px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"400px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"30px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Set an appointment","caption":"Come and meet us in person!\nLeave us your info and we will get back to you.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#696969","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"30px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"contact-form-7","value":{"id":"","class":"","cf7-id":"1408","padding-bottom":"30px"}}]}]}]';
				case 'home-barber':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","z-index":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2379","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"22px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Explore Our beauty products","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#696969","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"","bottom":"80px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are third generation barbers with a high level experience<br />and expertise in all aspects of our craft.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#696969","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"40px","bottom":"50px","left":"40px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2353","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2332","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"60px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"custom","overlay-icon-size-custom":"","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Haircut","caption":"Our products are natural, effective and especially gentle. We have experience collected during the many years.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#373737","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"15px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Lean More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#9e8462","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"12px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"12px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"40px","bottom":"50px","left":"40px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2354","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2332","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"60px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"custom","overlay-icon-size-custom":"","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Shaving","caption":"Our products are natural, effective and especially gentle. We have experience collected during the many years.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#373737","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"15px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Lean More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#9e8462","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"12px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"12px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#e7e7e7","hover-border-color":"#e7e7e7","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"40px","bottom":"50px","left":"40px","settings":"unlink"},"margin":{"top":"15px","right":"15px","bottom":"15px","left":"15px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2355","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2332","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"60px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"custom","overlay-icon-size-custom":"","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Facial","caption":"Our products are natural, effective and especially gentle. We have experience collected during the many years.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#373737","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"15px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Lean More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#9e8462","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"12px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"12px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"about-bg","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2382","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"300px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"about-bg","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2383","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"147px","right":"170px","bottom":"180px","left":"110px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"90px","right":"90px","bottom":"90px","left":"90px","settings":"unlink"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"80px","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Look and feel fantastic each day","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We empower men to look and feel fantastic each day, with great haircuts, beard trims, also tips on how to manage your style or beard with our award-winning men’s grooming products.</p><p>Asking you questions about your hairstyle, face shape and listening to what you want is all part of our consultation before we start your tailored service for you.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"About Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#9e8462","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"12px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"690px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"The finest men’s products since 1940","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Now it is your chance to take the Infinite Barber experience home with you and bring our selection of hairstyling, beard &amp; shaving products to your bathroom.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#696969","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"product","value":{"id":"","class":"","enable-category-filter":"disable","filterer-align":"left","filterer-all-icon":"none","category":"","tag":"","relation":"or","num-fetch":"3","stock-status":"all","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","product-style":"grid-3-with-border","enable-rating":"enable","attribute-field":"","variation-field":"","excerpt-number":"15","price-location":"after-title","display-attribute-amount":"","button-style":"plain","button-border-color":"","thumbnail-size":"Square Thumbnail","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"fitrows","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-size":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"default","product-title-font-size":"24px","product-title-font-weight":"400","product-title-letter-spacing":"0px","product-title-text-transform":"none","border-radius":"","frame-padding":"","frame-border-size":"","frame-border-color":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","product-title-color":"","product-title-hover-color":"","product-caption-color":"","product-caption-hover-color":"","box-background-color":"#f2f2f2","box-background-hover-color":"","carousel-bullet-top-margin":"","padding-bottom":"30px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"24px","title-font-weight":"400","title-letter-spacing":"0px","title-line-height":"","title-font-style":"normal","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Visit Our Shop","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/infinite/homepages/barber/shop-2/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#555555","icon-color":"#555555","text-hover-color":"","icon-hover-color":"","background-color":"#e7e7e7","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"12px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"12px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"column svc infinite v1"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"text-bg","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2384","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"90px","right":"100px","bottom":"120px","left":"190px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"90px","right":"70px","bottom":"90px","left":"70px","settings":"unlink"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"80px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Make your first impression count","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#373737","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are third generation barbers with a high level experience and expertise in all aspects of our craft.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2386","character":"","title":"01. Haircut","caption":"","caption-position":"bottom","content":"<p>Award-winning team of barbers with years of experience</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"24px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"400","title-font-style":"default","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"6px","right":"30px","bottom":"","left":""},"media-image-max-width":"60px","character-width":"","title-top-padding":"0px","title-bottom-margin":"0px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2387","character":"","title":"02. Styling","caption":"","caption-position":"bottom","content":"<p>The best way to get what you want from your barber</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"24px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"400","title-font-style":"default","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"6px","right":"30px","bottom":"","left":""},"media-image-max-width":"60px","character-width":"","title-top-padding":"0px","title-bottom-margin":"0px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2388","character":"","title":"03. Shaving","caption":"","caption-position":"bottom","content":"<p>Every service starts with an in-depth consultation</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"24px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"400","title-font-style":"default","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"normal","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"6px","right":"30px","bottom":"","left":""},"media-image-max-width":"60px","character-width":"","title-top-padding":"0px","title-bottom-margin":"0px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"20px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"text-bg","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2385","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"300px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2389","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Explore Our beauty products","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"22px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"500px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are third generation barbers with a high level experience and expertise in all aspects of our craft.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#696969","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"45px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Book Now","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#9e8462","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"12px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"12px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2390","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"115px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services & Pricing","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"price-list","value":{"id":"","class":"","tabs":[{"icon":"","icon-img":"","title":"Gentlemen’s Haircut                       ","price":"$30","caption":"Pulled Pork, French Beans, Fennel, Currant Vinaigrette."},{"icon":"","icon-img":"","title":"Haircut and Styling                       ","price":"$50","caption":"Cherry Tomato, Zucchini, Black Lentils, Clam Maltaise."}],"divider-style":"dashed","title-color":"#ffffff","price-color":"#ffffff","caption-color":"#f2f2f2","divider-color":"#ffffff","title-size":"20px","title-font-weight":"600","price-size":"20px","price-font-weight":"600","caption-size":"15px","caption-font-weight":"400","title-top-margin":"","list-bottom-margin":"45px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"price-list","value":{"id":"","class":"","tabs":[{"icon":"","icon-img":"","title":"Beard Shaper                                 ","price":" $30","caption":"Panisse, Beet, Fromage Frais, Crab Bisque, Poblano."},{"icon":"","icon-img":"","title":"Purifying Mask                               ","price":"   $45","caption":"Grilled Vegetables, Spicy Greens, Black Garlic."}],"divider-style":"dashed","title-color":"#ffffff","price-color":"#ffffff","caption-color":"#f2f2f2","divider-color":"#ffffff","title-size":"20px","title-font-weight":"600","price-size":"20px","price-font-weight":"600","caption-size":"15px","caption-font-weight":"400","title-top-margin":"","list-bottom-margin":"45px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"price-list","value":{"id":"","class":"","tabs":[{"icon":"","icon-img":"","title":"Children’s Haircut                            ","price":" $25","caption":"Whipped Potato, Turnip Variations, Spinach & Sorrel."},{"icon":"","icon-img":"","title":"Old World Shave                             ","price":"   $40","caption":"Corn Hushpuppy, Quinoa Crumble, Marjoram Gravy."}],"divider-style":"dashed","title-color":"#ffffff","price-color":"#ffffff","caption-color":"#f2f2f2","divider-color":"#ffffff","title-size":"20px","title-font-weight":"600","price-size":"20px","price-font-weight":"600","caption-size":"15px","caption-font-weight":"400","title-top-margin":"","list-bottom-margin":"45px","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f8f8f8","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2469","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"","bottom":"80px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"Martin Green","position":"","content":"<p>\"Great experience. Showed up early for my appointment, but quickly accommodated. Great service, haircut, beard trim and shave. Thank you!!\"</p>","image":"2364","image-img":"https://demo.goodlayers.com/infinite/homepages/barber/wp-content/uploads/sites/35/2022/02/b8.jpg","rating":"10"},{"title":"Thomas Scott","position":"","content":"<p>\"Great experience. Showed up early for my appointment, but quickly accommodated. Great service, haircut, beard trim and shave. Thank you!!\"</p>","image":"2360","image-img":"https://demo.goodlayers.com/infinite/homepages/barber/wp-content/uploads/sites/35/2022/02/b4.jpg","rating":"10"},{"title":"Vincent Harris","position":"","content":"<p>\"Great experience. Showed up early for my appointment, but quickly accommodated. Great service, haircut, beard trim and shave. Thank you!!\"</p>","image":"2365","image-img":"https://demo.goodlayers.com/infinite/homepages/barber/wp-content/uploads/sites/35/2022/02/b9.jpg","rating":"10"},{"title":"Paul Smith","position":"","content":"<p>\"Great experience. Showed up early for my appointment, but quickly accommodated. Great service, haircut, beard trim and shave. Thank you!!\"</p>","image":"2362","image-img":"https://demo.goodlayers.com/infinite/homepages/barber/wp-content/uploads/sites/35/2022/02/b6.jpg","rating":"10"},{"title":"Edward Anderson","position":"","content":"<p>\"Great experience. Showed up early for my appointment, but quickly accommodated. Great service, haircut, beard trim and shave. Thank you!!\"</p>","image":"2369","image-img":"https://demo.goodlayers.com/infinite/homepages/barber/wp-content/uploads/sites/35/2022/02/b02.jpg","rating":"10"},{"title":"Noah Roberts","position":"","content":"<p>\"Great experience. Showed up early for my appointment, but quickly accommodated. Great service, haircut, beard trim and shave. Thank you!!\"</p>","image":"2357","image-img":"https://demo.goodlayers.com/infinite/homepages/barber/wp-content/uploads/sites/35/2022/02/b1.jpg","rating":"10"},{"title":"Charlotte Martin","position":"","content":"<p>\"Great experience. Showed up early for my appointment, but quickly accommodated. Great service, haircut, beard trim and shave. Thank you!!\"</p>","image":"2370","image-img":"https://demo.goodlayers.com/infinite/homepages/barber/wp-content/uploads/sites/35/2022/02/b03.jpg","rating":"10"},{"title":"Pamela Williams","position":"","content":"<p>\"Great experience. Showed up early for my appointment, but quickly accommodated. Great service, haircut, beard trim and shave. Thank you!!\"</p>","image":"2367","image-img":"https://demo.goodlayers.com/infinite/homepages/barber/wp-content/uploads/sites/35/2022/02/b11.jpg","rating":"10"},{"title":"Ernest Lewis","position":"","content":"<p>\"Great experience. Showed up early for my appointment, but quickly accommodated. Great service, haircut, beard trim and shave. Thank you!!\"</p>","image":"2366","image-img":"https://demo.goodlayers.com/infinite/homepages/barber/wp-content/uploads/sites/35/2022/02/b10.jpg","rating":"10"}],"style":"block","content-top-padding":"0px","center-2-layout":"normal","chat-frame-background":"#ffffff","with-frame":"enable","column":"3","thumbnail-size":"thumbnail","enable-quote":"custom-image","quote-image":"2356","left-quote-position":"left","quote-position":"bottom","rating-position":"left","rating-top-margin":"","carousel":"enable","carousel-left-title":"","carousel-left-content":"","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"none","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-side-margin":"","carousel-navigation-icon-margin":"","carousel-nav-style":"default","carousel-bullet-style":"round gdlr-core-color-bullet","quote-size":"50px","quote-font-weight":"","quote-height":"","quote-top-margin":"","quote-bottom-margin":"","title-size":"30px","title-text-transform":"uppercase","title-font-weight":"500","title-letter-spacing":"","content-size":"16px","mobile-content-size":"","content-line-height":"","content-font-style":"normal","content-font-weight":"400","content-letter-spacing":"0px","name-size":"16px","name-font-weight":"500","name-font-style":"","name-letter-spacing":"0px","name-text-transform":"none","caption-size":"","position-font-style":"","position-font-weight":"","rating-font-size":"14px","frame-border-size":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"frame-border-color":"","frame-hover-border-color":"","frame-border-radius":"","frame-border-radius2":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"frame-shadow-size":{"x":"","y":"5px","size":"40px","settings":"unlink"},"frame-shadow-color":"#030f27","frame-shadow-opacity":"0.1","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-border-width":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"frame-hover-shadow-size":{"x":"","y":"5px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.1","title-color":"","caption-color":"#696969","quote-color":"","content-color":"#696969","name-color":"#222222","position-color":"","star-rating-color":"#9d8463","frame-background-color":"","hover-quote-color":"","hover-content-color":"","hover-name-color":"","hover-position-color":"","hover-star-rating-color":"","hover-frame-background-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"30px","carousel-bullet-top-margin":"80px","padding-bottom":""}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2393","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"90px","right":"580px","bottom":"80px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"300px","bottom":"","left":"","settings":"unlink"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"80px","right":"20px","bottom":"60px","left":"20px","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Subscribe to Our Newsletter get a 10% discount code!","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}},{"template":"element","type":"newsletter","value":{"id":"","class":"","style":"rectangle","shadow-size":"","shadow-color":"","shadow-opacity":"0.2","padding-bottom":"30px"}}]}]}]';
				case 'home-jewelry':
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"30px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","z-index":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2339","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"repeat-y","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"65px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"650px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"75px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Every piece of jewelry has its own unique digital certificate","caption":"","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#373737","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"100px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#b79f82"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"-46px","bottom":"0px","left":"-80px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"9454","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2332","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","mobile-alignment":"","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Discover the traceability of your jewelry & precious metals","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"30px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>At Infinite, we are committed to sustainability and responsible growth. As part of our commitment to sustainable and ethical practices across the entire supply chain, we are pioneers in presenting the complete traceability of a jewel, from the metal-recycling process to its delivery into your hands.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#373737","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"About Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"left","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"20px","right":"45px","bottom":"20px","left":"45px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#b79f82","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"lb-video","button2-custom-image":"2337","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"13px","right":"33px","bottom":"13px","left":"33px","settings":"unlink"},"border2-radius":"0px","button2-background":"transparent","button2-border":"enable","border2-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#b79f82","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"#b79f82","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"25px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f2f1f0","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2339","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"repeat-y","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"75px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"45","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Best sellers — The must-haves","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"100px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#b79f82"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"right","mobile-alignment":"left","full-width-button":"disable","button-padding":{"top":"20px","right":"44px","bottom":"20px","left":"44px","settings":"unlink"},"border-radius":"0px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#999999","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"0px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#999999","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"50px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"product","value":{"id":"","class":"","enable-category-filter":"disable","filterer-align":"left","filterer-all-icon":"none","category":"","tag":"","relation":"or","num-fetch":"9","stock-status":"all","orderby":"menu_order","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","product-style":"grid-3-with-border","enable-rating":"enable","attribute-field":"","variation-field":"","excerpt-number":"15","price-location":"after-title","display-attribute-amount":"","button-style":"plain","button-border-color":"","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"15","layout":"carousel","carousel-overflow":"","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation-outer","carousel-navigation-show-on-hover":"enable","carousel-navigation-align":"center","carousel-navigation-left-icon":"icon-arrow-left","carousel-navigation-right-icon":"icon-arrow-right","carousel-navigation-icon-color":"#a8a8a8","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-size":"-22px","carousel-navigation-margin":"","carousel-navigation-icon-margin":"-22px","carousel-bullet-style":"default","product-title-font-size":"22px","product-title-font-weight":"400","product-title-letter-spacing":"0px","product-title-text-transform":"none","border-radius":"","frame-padding":"","frame-border-size":"0px","frame-border-color":"#e7e7e7","frame-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-shadow-color":"","frame-shadow-opacity":"0.15","enable-move-up-shadow-effect":"disable","move-up-effect-length":"0px","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.15","product-title-color":"","product-title-hover-color":"","product-caption-color":"","product-caption-hover-color":"","box-background-color":"","box-background-hover-color":"","carousel-bullet-top-margin":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"bottom","read-more-style":"default","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"22px","title-font-weight":"400","title-letter-spacing":"0px","title-line-height":"","title-font-style":"","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"#002e5b","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2339","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"repeat-y","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"black column jewelry svc"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"10px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our production techniques","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"30px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Electroforming","caption":"A technique that has been used by our professionals for more than 20 years, the result of a large investment into innovative new technologies.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"22px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#373737","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Sintering","caption":"A technique that has been used by our professionals for more than 20 years, the result of a large investment into innovative new technologies.","caption-position":"bottom","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"22px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"18px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#373737","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#b79f82","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"lb-video","button2-custom-image":"2337","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"13px","right":"33px","bottom":"13px","left":"33px","settings":"unlink"},"border2-radius":"0px","button2-background":"transparent","button2-border":"enable","border2-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#b79f82","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"#b79f82","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"13px","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"25px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"-69px","bottom":"0px","left":"-20px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"2362","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"2332","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2364","character":"","title":"Free Shipping","caption":"","caption-position":"bottom","content":"<p>Orders over $100</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"20px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"20px","bottom":"","left":""},"media-image-max-width":"32px","character-width":"","title-top-padding":"","title-bottom-margin":"9px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2365","character":"","title":"Free Support","caption":"","caption-position":"bottom","content":"<p>After-sales support</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"20px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"20px","bottom":"","left":""},"media-image-max-width":"40px","character-width":"","title-top-padding":"","title-bottom-margin":"9px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2366","character":"","title":"Best Price","caption":"","caption-position":"bottom","content":"<p>Guaranteed price</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"20px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"20px","bottom":"","left":""},"media-image-max-width":"40px","character-width":"","title-top-padding":"","title-bottom-margin":"9px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"2367","character":"","title":"Free Returns","caption":"","caption-position":"bottom","content":"<p>Free &amp; easy returns</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"20px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"500","title-letter-spacing":"0px","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-text-transform":"","content-size":"18px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"20px","bottom":"","left":""},"media-image-max-width":"40px","character-width":"","title-top-padding":"","title-bottom-margin":"9px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"30px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2369","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"240px","right":"0px","bottom":"240px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"tablet-padding":{"top":"130px","right":"","bottom":"130px","left":"","settings":"unlink"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"800px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Subscribe to our newsletter and receive exclusive offers direct in your inbox","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p> Join our newsletter and get a 10% discount off your first purchase! Enter your email address in the pop up to discover your code</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"20px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#ffffff","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"25px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Subscribe","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"center","mobile-alignment":"","full-width-button":"disable","button-padding":{"top":"20px","right":"45px","bottom":"20px","left":"45px","settings":"unlink"},"border-radius":"0px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#b79f82","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"lb-video","button2-custom-image":"2337","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"13px","right":"33px","bottom":"13px","left":"33px","settings":"unlink"},"border2-radius":"0px","button2-background":"transparent","button2-border":"enable","border2-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#b79f82","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"#b79f82","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"25px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f2f1f0","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2339","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"repeat-y","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"30px","bottom":"0px","left":"30px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"45","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Top amazon product categories","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"36px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"100px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#b79f82"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"1px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","z-index":"","text-align":"right","mobile-alignment":"left","full-width-button":"disable","button-padding":{"top":"20px","right":"44px","bottom":"20px","left":"44px","settings":"unlink"},"border-radius":"0px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#999999","icon-color":"","text-hover-color":"","icon-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button-skewx":"","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"0px","button2-background":"solid","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#999999","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","button2-skewx":"","text-size":"13px","text-font-style":"normal","text-font-weight":"600","text-letter-spacing":"1px","text-transform":"uppercase","icon-size":"","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"60px","right":"2px","bottom":"10px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"product","value":{"id":"","class":"","enable-category-filter":"disable","filterer-align":"left","filterer-all-icon":"none","category":"","tag":"","relation":"or","num-fetch":"9","stock-status":"all","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","product-style":"grid-6","enable-rating":"enable","attribute-field":"","variation-field":"","excerpt-number":"15","price-location":"after-title","display-attribute-amount":"","button-style":"plain","button-border-color":"#ffffff","thumbnail-size":"full","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","column-size":"15","layout":"carousel","carousel-overflow":"","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"navigation-outer","carousel-navigation-show-on-hover":"enable","carousel-navigation-align":"center","carousel-navigation-left-icon":"icon-arrow-left","carousel-navigation-right-icon":"icon-arrow-right","carousel-navigation-icon-color":"#a8a8a8","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-size":"25px","carousel-navigation-margin":"","carousel-navigation-icon-margin":"-40px","carousel-bullet-style":"default","product-title-font-size":"22px","product-title-font-weight":"400","product-title-letter-spacing":"0px","product-title-text-transform":"none","border-radius":"","frame-padding":"","frame-border-size":"1px","frame-border-color":"#e7e7e7","frame-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-shadow-color":"#ffffff","frame-shadow-opacity":"0.15","enable-move-up-shadow-effect":"disable","move-up-effect-length":"0px","frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#030f27","frame-hover-shadow-opacity":"0.15","product-title-color":"","product-title-hover-color":"","product-caption-color":"","product-caption-hover-color":"","box-background-color":"","box-background-hover-color":"","carousel-bullet-top-margin":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"bottom","read-more-style":"default","read-more-text":"","read-more-link":"","read-more-target":"_self","title-size":"22px","title-font-weight":"400","title-letter-spacing":"0px","title-line-height":"","title-font-style":"","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"#002e5b","caption-color":"","read-more-color":"","read-more-divider":"none","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"99","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"2339","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"repeat-y","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"enable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"30px","bottom":"-90px","left":"30px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-order":"","tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-order":"","mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Follow us on Instagram","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#002e5b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"100px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#b79f82"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"gallery","value":{"id":"","class":"","gallery":[{"id":"2349","thumbnail":"https://demo.goodlayers.com/infinite/homepages/jewelry/wp-content/uploads/sites/37/2022/03/img01-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2350","thumbnail":"https://demo.goodlayers.com/infinite/homepages/jewelry/wp-content/uploads/sites/37/2022/03/img02-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2351","thumbnail":"https://demo.goodlayers.com/infinite/homepages/jewelry/wp-content/uploads/sites/37/2022/03/img03-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"},{"id":"2352","thumbnail":"https://demo.goodlayers.com/infinite/homepages/jewelry/wp-content/uploads/sites/37/2022/03/img04-150x150.jpg","link-to":"none","custom-image":"","video-url":"","page-id":"2","custom-url":"","custom-link-target":"_self"}],"random":"disable","pagination":"none","show-amount":"20","pagination-style":"default","pagination-align":"default","style":"grid-no-space","max-slider-height":"500px","overlay":"none","icon-hover-style":"icon_zoom-in_alt","show-caption":"disable","overlay-on-hover":"disable","column":"4","layout":"fitrows","slider-navigation":"navigation","slider-bullet-style":"default","slider-effects":"default","enable-direction-navigation":"disable","thumbnail-navigation":"below-slider","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","grid-slider-navigation":"navigation","carousel-bullet-style":"default","thumbnail-size":"full","slider-thumbnail-size":"medium","overlay-color":"","overlay-opacity":"","border-radius":"","image-left-right-margin":"","image-bottom-margin":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#222222","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-gradient-opacity":"1","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"60px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]';
				case 'home-agency01':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"#2d2d2d","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"67px","right":"80px","bottom":"65px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#2d9bea","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light Blue","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_compass_alt","icon-style":"normal","image":"","title":"GoodLayers Page Builder","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"34px","icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"7px","title-bottom-margin":"20px","caption-size":"17px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"67px","right":"80px","bottom":"65px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#282828","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lightbulb_alt","icon-style":"normal","image":"","title":"Unlock Your Ideas","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"34px","icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"7px","title-bottom-margin":"20px","caption-size":"17px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"67px","right":"80px","bottom":"65px","left":"80px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#4b76e3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light Purple","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_cloud-upload_alt","icon-style":"normal","image":"","title":"Powerful Performance","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"34px","icon-color":"","icon-background":"","title-size":"18px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"7px","title-bottom-margin":"20px","caption-size":"17px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"95px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"326px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"image","value":{"id":"","image":"22","thumbnail-size":"full","link-to":"none","custom-image":"","video-url":"","page-id":"7","custom-url":"","custom-link-target":"_self","enable-caption":"disable","max-width":"","alignment":"center","enable-shadow":"disable","frame-style":"rectangle","border-radius":"3px","border-width":"0px","border-color":"","overlay-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"40","items":[{"template":"element","type":"accordion","value":{"id":"","tabs":[{"title":"A wonderful serenity has taken","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet.\n\n<a href=\"#\">Learn More</a>"},{"title":"I sink under the weight of the splendour","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet.\n\n<a href=\"#\">Learn More</a>"},{"title":"I throw myself down among the tall grass","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet.\n\n<a href=\"#\">Learn More</a>"},{"title":"Far far away, behind the word mountains","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. \n\n<a href=\"#\">Learn More</a>"}],"active":"1","style":"background-title-icon","align":"left","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"Light Purple","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_clock_alt","icon-style":"normal","image":"","title":"SAVE A LOT OF YOUR TIME","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"#4b76e3","padding":{"top":"49px","right":"65px","bottom":"25px","left":"65px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"fa fa-comments-o","icon-style":"normal","image":"","title":"Best Support Ever","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"#2d9bea","padding":{"top":"49px","right":"65px","bottom":"25px","left":"65px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_lock_alt","icon-style":"normal","image":"","title":"Very Secure Code","caption":"","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.","read-more-text":"","read-more-link":"#","style":"left_icon-left","icon-size":"28px","media-margin":{"top":"5px","right":"","bottom":"","left":""},"icon-color":"","icon-background":"","title-size":"14px","title-font-weight":"","title-letter-spacing":"","title-top-padding":"","title-bottom-margin":"","caption-size":"14px","caption-top-margin":"","content-size":"15px","read-more-size":"14px","read-more-top-margin":"","background-color":"#4b59e3","padding":{"top":"49px","right":"65px","bottom":"25px","left":"65px"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"40","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInRight","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-2","centering-sync-height-content":"enable","background-type":"image","background-extending":"none","background-color":"","background-image":"1288","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"60px","right":"65px","bottom":"60px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"skin":"Light"},"items":[{"template":"element","type":"stunning-text","value":{"id":"","caption":"Sections and wrapper can be manage easily","title":"With brand new <br/>GoodLayers page builder","content":"","button-text":"","button-link":"#","button-link-target":"_self","text-align":"left","caption-position":"above-title","title-size":"41px","caption-size":"16px","content-size":"16px","link-size":"15px","padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>\n<p>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn\'t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back.</p>\n","text-align":"left","font-size":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"75px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Grey","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"portfolio","value":{"id":"","category":null,"tag":null,"num-fetch":"9","thumbnail-size":"Portfolio Thumbnail","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"grid","portfolio-grid-text-align":"left","portfolio-grid-style":"with-frame","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"20","layout":"carousel","carousel-navigation":"navigation","excerpt":"none","excerpt-number":"55","show-read-more":"enable","title-align":"left","title":"Recent works","caption":"Explore","read-more-text":"View More Works","read-more-link":"#","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"65px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Grey","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"100","suffix":"%","divider":"disable","bottom-text":"Satisfaction","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"588","suffix":"","divider":"disable","bottom-text":"Projects","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"14000","end-number":"16800","suffix":"","divider":"disable","bottom-text":"Working Hours","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"counter","value":{"id":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"","prefix":"","start-number":"0","end-number":"234","suffix":"","divider":"disable","bottom-text":"Lovely Clients","top-icon-size":"30px","top-text-size":"16px","number-size":"33px","bottom-text-size":"16px","animation-time":"4000","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"110px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1318","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.2","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Pricing plans","caption":"Go with your right one","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"37px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"#c7e3ff","caption-spaces":"10px","padding-bottom":"55px"}},{"template":"element","type":"price-table","value":{"id":"","tabs":[{"icon":"icon_genius","image":"","image-img":"","title":"Standard Plan","caption":"Price default caption","price":"99","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"},{"icon":"fa fa-star-o","image":"","image-img":"","title":"professional plan","caption":"Price default caption","price":"129","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"enable"},{"icon":"icon_lightbulb_alt","image":"","image-img":"","title":"Enterprise plan","caption":"Price default caption","price":"299","content":"[gdlr_core_price_list icon=\"fa fa-check\" ]<ul>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n<li>Price default list</li>\n</ul>[/gdlr_core_price_list]","button-text":"Learn More","button-link":"#","feature-price":"disable"}],"price-prefix":"$","price-suffix":"/ MO","padding-bottom":"30px","header-color":"","header-gradient-color":"","icon-color":"","title-color":"","caption-color":"","price-background-color":"","price-prefix-color":"","price-text-color":"","price-suffix-color":"","content-background-color":"","content-color":"","content-border-color":"","button-text-color":"","button-background-color":"#404040","button-background-gradient-color":"#565656","a-header-color":"","a-header-gradient-color":"","a-icon-color":"","a-title-color":"","a-caption-color":"","a-price-background-color":"","a-price-prefix-color":"","a-price-text-color":"","a-price-suffix-color":"","a-content-background-color":"","a-content-color":"","a-content-border-color":"","a-button-text-color":"","a-button-background-color":"#319dea","a-button-background-gradient-color":"#51aae9"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"85px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#f1f1f1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"blog","value":{"id":"","category":"","tag":"","num-fetch":"9","prepend-sticky":"enable","thumbnail-size":"full","orderby":"date","order":"desc","pagination":"none","pagination-style":"default","pagination-align":"default","blog-style":"blog-column-with-frame","show-thumbnail":"disable","column-size":"20","layout":"carousel","carousel-navigation":"bullet","item-size":"small","excerpt":"specify-number","excerpt-number":"30","meta-option":["date","author","category","comment-number"],"show-read-more":"enable","title-align":"center","title":"Recent News","caption":"Get updates from us","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"37px","caption-size":"18px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","padding-bottom":"50px"}},{"template":"element","type":"button","value":{"id":"","button-text":"More News","link-to":"custom-url","custom-image":"","video-url":"","button-link":"http://demo.goodlayers.com/infinite/blog","button-link-target":"_blank","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"boxed","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"0px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"pulse","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"#1a1a1a","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"Where are we?","caption":"Come and see us","caption-position":"bottom","title-link":"","title-link-target":"_self","text-align":"center","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h6","title-font-size":"37px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"1px","title-font-uppercase":"enable","title-color":"#ffffff","title-link-hover-color":"","caption-font-size":"18px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"#7a7a7a","caption-spaces":"10px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"wp-google-map-plugin","value":{"id":"","wpgmap-id":"1","padding-bottom":"0px"}}]}]';
				case 'home-aperture':
					return '[{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","revolution-slider-id":"1","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"60px","bottom":"40px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_film","icon-style":"normal","image":"","title":"MV/Ad Filming","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"37px","media-margin":{"top":"","right":"","bottom":"48px","left":""},"icon-color":"#121212","icon-background":"","title-size":"16px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"35px","caption-size":"14px","caption-top-margin":"","content-size":"17px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#202020","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"60px","bottom":"40px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#2f2f2f","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_camera_alt","icon-style":"normal","image":"","title":"Photograph service","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"37px","media-margin":{"top":"","right":"","bottom":"48px","left":""},"icon-color":"#ffffff","icon-background":"","title-size":"16px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"35px","caption-size":"14px","caption-top-margin":"","content-size":"17px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"#353535","text-hover-color":"","background-color":"#ffffff","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"80px","right":"60px","bottom":"40px","left":"60px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"fadeInDown","animation-location":"0.8","full-height":"disable","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"#f3f3f3","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"column-service","value":{"id":"","media-type":"icon","icon":"icon_pencil","icon-style":"normal","image":"","title":"Re-touch service","caption":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot.","read-more-text":"","read-more-link":"#","style":"center_icon-top","icon-size":"37px","media-margin":{"top":"","right":"","bottom":"48px","left":""},"icon-color":"#121212","icon-background":"","title-size":"16px","title-font-weight":"700","title-letter-spacing":"","title-text-transform":"uppercase","title-top-padding":"","title-bottom-margin":"35px","caption-size":"14px","caption-top-margin":"","content-size":"17px","read-more-size":"14px","read-more-top-margin":"","background-color":"","padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}},{"template":"element","type":"button","value":{"id":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"none","icon":"fa fa-gear","text-align":"center","text-size":"13px","icon-size":"","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"3px","button-background":"solid","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"text-color":"","text-hover-color":"","background-color":"#202020","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"120px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"animation":"fadeInUp","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","overflow":"visible","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","max-width":"620px","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"animation":"none","animation-location":"0.8","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-extending":"none","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"Dark","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"title","value":{"id":"","title":"My Photos","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","title-font-size":"35px","title-font-weight":"800","title-font-style":"normal","title-font-letter-spacing":"2px","title-font-uppercase":"enable","title-color":"","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"35px"}},{"template":"element","type":"divider","value":{"id":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","icon-size":"15px","divider-size":"3px","divider-width":"45px","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","content":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm","text-align":"center","font-size":"17px","padding-bottom":"40px"}}]},{"template":"element","type":"portfolio","value":{"id":"","category":"","tag":"","num-fetch":"12","thumbnail-size":"Portfolio Thumbnail","orderby":"date","order":"desc","filterer":"text","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","portfolio-style":"modern-no-space","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","enable-portfolio-tag":"enable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"margin-icon-title-tag","column-size":"15","layout":"fitrows","carousel-navigation":"navigation","excerpt":"specify-number","excerpt-number":"55","show-read-more":"enable","title-align":"left","title":"","caption":"","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","caption-size":"16px","read-more-size":"14px","title-color":"","caption-color":"","read-more-color":"","read-more-divider-color":"","overlay-color":"","overlay-opacity":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"custom","max-width":"820px","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"110px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"image","background-color":"","background-image":"1369","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.3","skin":"light","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"element","type":"testimonial","value":{"id":"","title":"Testimonial","caption":"","tabs":[{"title":"Jennifer Smith","position":"Photographer","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. ","image":"1370","image-img":"http://demo.goodlayers.com/infinite/homepages/aperture/wp-content/uploads/sites/14/2016/05/testimonial-1.jpg"},{"title":"John Doe","position":"Artist","content":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. ","image":"1371","image-img":"http://demo.goodlayers.com/infinite/homepages/aperture/wp-content/uploads/sites/14/2016/05/testimonial-2.jpg"}],"column":"1","carousel":"enable","carousel-navigation":"navigation","style":"center","title-size":"41px","caption-size":"16px","content-size":"19px","title-color":"","caption-color":"","quote-color":"#ffffff","content-color":"#bbbbbb","name-color":"","position-color":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"background","value":{"id":"","content-layout":"full","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"animation":"none","animation-location":"0.8","full-height":"disable","centering-content":"disable","background-type":"color","background-color":"","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","pattern-opacity":"1","parallax-speed":"0.8","skin":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid"},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","min-height":"","hide-this-wrapper-in":"none","animation":"fadeInLeft","animation-location":"0.8","full-height":"disable","decrease-height":"0px","sync-height":"height-1","centering-sync-height-content":"enable","background-type":"color","background-extending":"none","background-color":"#f0f0f0","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"1","parallax-speed":"0.8","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","padding":{"top":"50px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"15px","bottom":"0px","left":"0px","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","title":"Blog","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"140px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#b2b2b2","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","title":"Get updates","caption":"","caption-position":"top","title-link":"","title-link-target":"_self","text-align":"center","left-image":"","enable-side-border":"disable","side-border-size":"1px","side-border-spaces":"30px","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h5","title-font-size":"35px","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-font-uppercase":"disable","title-color":"#313131","title-link-hover-color":"","caption-font-size":"16px","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","caption-color":"","caption-spaces":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","max-width":"","hide-this-wrapper-in":"none","padding":{"top":"120px","right":"0px","bott